/*
 *  author:Oliver尹
 *  qq:752746873
 */

(function(root,func,plugin){
    func(jQuery,plugin)
})(this,function(jQuery,plugin){

    const defaultName = '谢谢惠顾';
    //奖品列表上限数量8
    const maxListNumber = 8;
    const puginID = 'oliverPrizeDraw';
    const row = 3;
    const column = 3;

    let flg=false;
    let _this_;
    $.fn[plugin] = function(params) {
        let _this = this;
        if(!isObj(params)) throwError('传入的参数必须是一个对象');

        //生成抽奖数组
        params.prizeList = finalList(params.prizeList);

        let createDOMList = createDomListArr(params.prizeList);
        
        //创建DOM并返回按钮ID
        let btn = createDOM(createDOMList,_this);
        let boxChinldren = btn.boxId;
        
        $('#'+btn.startBtn).on('click',function(){
            _this_ = this;
            if(!flg){
                $(_this_).addClass('start-btn-disable').removeClass('start-btn-able');
                flg = true;
                //初始化参数
                initParam();
                //判断是否有指定奖品ID
                if(params.finalPrizeID&&isString(params.finalPrizeID)){

                    let array = [];
                    params.prizeList.forEach(element => {
                        if(element.id === params.finalPrizeID){
                            array.push(element);
                        }
                    })

                    switch(array.length){
                        case 0:
                            console.log('指定的奖品ID在奖品列表中不存在，将按指定概率进行抽奖');
                            targetPrize(params.prizeList,boxChinldren);
                            break
                        case 1:
                            let name = array[0].name?array[0].name:'默认名字';
                            console.log('指定奖品为:'+name);
                            targetPrize(array[0],boxChinldren);
                            break
                        default:
                            throwError('指定的最终奖品ID在奖品列表中不唯一');
                            break;
                    }
                }
                else{
                    console.log('无指定奖品，将按指定概率进行抽奖');
                    targetPrize(params.prizeList,boxChinldren);
                }
            }
        })
    }

    //执行抽奖,传入的正常抽奖或者是指定奖品,dom列表
    function targetPrize(params,dom){
        //如果是对象，执行指定奖品，如果是数组，执行概率抽奖
        isObj(params)?
        pointPrize(params,dom):
        Array.isArray(params)?
        percentPrize(params,dom):
        throwError('targetPrize()参数错误');
    }
    
    //指定奖品
    function pointPrize(params,dom){
        //指定产品的位置
        let ax = targetIndex(params,dom)
        console.log(params);
        speedUp(dom,ax);
    }

    //概率抽奖
    function percentPrize(params,dom){
        //将概率转成数组区间
        let newArr = arrayPercent(params);
        //获得最终奖品
        let percent = objPercent(newArr);
        console.log(percent);

        //指定产品的位置
        let ax = targetIndex(percent,dom)
        speedUp(dom,ax);

    }

    //默认时间
    const normalTime = 50,maxTime=300;
    //转动次数
    const normal = 2400/normalTime;
    let timer,i,t;
    let v;
    const a=-20;

    function initParam(){
        v=maxTime;
        i=-1;
        t=0;
    }
    //执行动画，加速
    function speedUp(dom,index){
        runAnimate(dom);
        if(v<=normalTime){
            v=normalTime;
            clearTimeout(timer);
            speedNormal(dom,index);
        }
        else{
            v = v+a;
            timer = setTimeout(()=>{
                speedUp(dom,index)
            }, v);
        }
    }
    //执行动画，匀速
    function speedNormal(dom,index){
        runAnimate(dom);
        timer = setTimeout(() => {
            speedNormal(dom,index);
        }, v);
        if(t >= normal){
            clearTimeout(timer);
            t=0;
            speedDown(dom,index);
        }
        else{
            t++;
        }
    }
    //转成DOM，减速
    function speedDown(dom,index){
        runAnimate(dom);
        if(v>=maxTime+8*a){
            clearTimeout(timer)
            timer = setTimeout(()=>{
                if(i == index){
                    clearTimeout(timer);
                    flg = false;
                    $(_this_).removeClass('start-btn-disable').addClass('start-btn-able');
                }
                else{
                    speedDown(dom,index)
                }
            },v)
        }
        else{
            v = v-a;
            timer = setTimeout(() => {
                speedDown(dom,index);
                
            }, v);
        }
    }

    //选中dom对象
    function runAnimate(dom){
        if(i<7){
            i++;
        }
        else{
            i=0;
        }
        $('#'+dom).children().removeClass('selected').eq(i).addClass('selected');
    }

    //将概率转成区间数组
    function arrayPercent(arr){
        let sum = 0;
        let newArr=[];

        arr.forEach((el)=>{
            el.percent&&isNumber(el.percent)?
            newArr.push({
                name:el.name,
                id:el.id,
                percent:[sum,(sum+el.percent)===100?(sum=sum+el.percent):(sum=sum+el.percent)-1]
            }):'';
        })
        return newArr;
    }

    //选出一个随机数并返回指定区间的对象
    function objPercent(arr){
        let radomNum = Math.floor(Math.random() * 100);
        console.log(radomNum);
        for(let el of arr){
            if(radomNum >= el.percent[0] && radomNum <= el.percent[1]){
                return el;
            }
        }
    }

    function targetIndex(params,dom){
        let arr = []
        $('#'+dom).children().each((index,el)=>{
            if(el.dataset.id===params.id){
                arr.push(index);
            }
        })
        return arr[0];

    }
    function createDomListArr(arr){
        let newArr = [];
        arr.forEach((el,index) => {
            newArr.push(`<div data-id='${el.id}' index='${index}'>${el.name}</div>`)
        })
        return newArr;
    }

    //创建DOM
    function createDOM(list,dom){
        let div = `<div id='${puginID+'Box'}'></div>`;
        let divContainer = `<div id='${puginID+'Container'}'></div>`;
        dom.append(divContainer);
        $('#'+puginID+'Container').append(div);

        let box = $('#'+puginID+'Box');
        box.append(list);
        // dom.append(list);
        let children = box.children();
        // console.log(children)
        children.css({
            'width':box.width()/row-4+'px',
            'height':box.height()/column-4+'px',
            'line-height':box.height()/column-4+'px',
        })
        children.each((index,el)=>{
            if(index >= 0 && index < (row-1)){
                $(el).css({
                    'top':0,
                    'left':index*(box.width()/row)+'px'
                })
            }
            else if(index>=row-1 && index<row+column-1){
                $(el).css({
                    'right':0,
                    'top':(index-2)*(box.height()/column)+'px'
                })
            }
            else if(index>=row-1+column&&index<(2*row+column-2)){
                $(el).css({
                    'bottom':0,
                    'right':(index-(row+column-2))*(box.width()/row)+'px'
                })
            }
            else{
                $(el).css({
                    'top':(index-(2*(row+column)-6))*(box.height()/column)+'px',
                    'left':0
                })
            }
        })

        let startBtn = `<span id='${puginID+'StartBtn'}' class='start-btn start-btn-able'>开始</span>`;
        box.parent().append(startBtn);
        $('#'+puginID+'StartBtn').css({
            'width':box.width()/row-4+'px',
            'height':box.height()/column-4+'px',
            'line-height':box.height()/column-4+'px',               
            'left':box.width()/row+'px',
            'top':box.height()/column+'px',
            // 'transform':'translate(-50%,-50%)'
        })
        return {
            startBtn:puginID+'StartBtn',
            boxId:puginID+'Box'
        }
    }

    //合并奖品列表
    function finalList(arr){
        //存在且必须是数组
        if(!(arr && Array.isArray(arr))){
            let newArr = [];
            for(let i = 0 ; i < maxListNumber ; i++){
                newArr.push({
                    name:defaultName,
                    id:puginID + i,
                    percent:100 / maxListNumber
                });
            }
            return newArr;
        }
        arr.forEach((el)=>{
            if(!isNumber(el.percent)){
                throwError('奖品列表的percent的值必须是数字类型，当前ID为:'+el.id+' 的percent值不是数字');
            }
        })
        //奖品列表长度
        if(arr.length === maxListNumber){
            let percent = resultPro(arr);
            if(percent !== 100) throwError('奖品列表的概率和必须是100，当前是：'+percent);
            return arr;
        }
        else{
            let length = maxListNumber - arr.length;
            length = length > 0 ? length : throwError('奖品列表的数量上限是：'+maxListNumber+'，当前是：'+arr.length);
            //当前概率和
            let current = resultPro(arr);
            if(current>100) throwError('奖品列表的概率和必须小于100，当前是：'+current);

            for(let i = 0 ; i < length ; i++){
                arr.push({
                    name:defaultName,
                    id:puginID + i,
                    percent:(100 - current) / length
                })
            }
            return arr.sort(randomArr);
        }

    }
    //判断当前的奖品列表的概率总计
    function resultPro(arr){
        if(!Array.isArray(arr)) throwError('resultPro的参数必须是数组');

        let result = 0;
        arr.forEach((el) => {
            el.percent && isNumber(el.percent)? result = result + el.percent : '';
        })

        return result;
    }

    //打乱数组
    function randomArr(a,b){
        return Math.random()>.5 ? -1 : 1;
    }

    //抛出异常
    function throwError(val){
        throw new Error(val)
    }

    //是否是个对象
    function isObj(obj){
        return Object.prototype.toString.call(obj) === '[object Object]';
    }
    //是否是个正则
    function isRegExp(reg){
        return Object.prototype.toString.call(reg) === '[object RegExp]';
    }
    //是否是布尔值
    function isBoolean(boolean){
        return Object.prototype.toString.call(boolean) === '[object Boolean]';
    }
    //是否是字符串
    function isString(string){
        return Object.prototype.toString.call(string) === '[object String]';
    }
    //是否是数字
    function isNumber(number){
        return Object.prototype.toString.call(number) === '[object Number]';
    }
},'prizeDraw')