(function(window) {
	console.log('作者QQ：657837529，欢迎交流')
	function drawCircle(param) {
		// 切割份数
		var counts = 500;
		// 容器宽高
		var width = 0;
		var height = 0;
		// 圆环中心点
		var ox = 0;
		var oy = 0;
		// 圆弧半径\n
		var r = 50;
		// 内部圆半径占比
		var or = 0.8;
		// 画布
		var ctx = null;
		// 数据
		var data = [];
		// 默认颜色
		var defaults = [];
		// 记录鼠标所在数据域
		var mouseIndex = -1;
		// 总计
		var total = 0;
		// 偏角，修改起始点位置
		var dAngle = -Math.PI/2;
		// 数据值折线样式
		var valueLine = {
			line1: {
				length: 50
			},
			line2: {
				length: 20
			},
			text: {
				fontSize: 22
			},
			color: '#434343'
		}
		// 中心位置label样式
		var centerLabel = {
			fontSize: 30,
			color: '#434343'
		}
		// 图例
		var legend = {
			show: false,
			text: {
				color: '#fff',
				fontSize: '16px'
			},
			position: 'bottom', // 只有 'top'和'bottom'
		}
		
		// 设置中心name样式
		function setNameStyle(nameStyle) {
			// 设置中心文字样式
			if(nameStyle.color) {
				centerLabel.color = nameStyle.color;
			}
			if(nameStyle.fontSize) {
				centerLabel.fontSize = parseFloat(nameStyle.fontSize);
			}
		}
		
		// 设置数据label样式
		function setDataLabelStyle(labelStyle) {
			// 设置中心文字样式
			if(labelStyle.color) {
				valueLine.color = labelStyle.color;
			}
			if(labelStyle.fontSize) {
				valueLine.text.fontSize = parseFloat(labelStyle.fontSize);
			}
		}
		
		// 修改图例样式
		function setLegendStyle(legnedStyle) {
			if(legnedStyle.show) {
				legend.show = legnedStyle.show;
			}
			if(legnedStyle.text) {
				if(legnedStyle.text.color) {
					legend.text.color = legnedStyle.text.color;
				}
				if(legnedStyle.text.fontSize) {
					legend.text.fontSize = parseFloat(legnedStyle.text.fontSize) + 'px';
				}
			}
			if(legnedStyle.position) {
				legend.position = legnedStyle.position;
			}
		}
		
		function DrawCircle(param) {
			var self = this;
			var el = createDom(param.id)
			
			// 容器宽高
			width = el.clientWidth;
			height = el.clientHeight;
			// 设置中心文字样式
			setNameStyle(param.nameStyle || centerLabel);
			// 设置label样式
			setDataLabelStyle(param.labelStyle || {})
			// 计算中心点
			getCenterPoint();
			// 设置legend 样式
			setLegendStyle(param.legend || {});
			// 计算圆弧半径
			getRadius(param.radius);
			// 计算折线长度
			getLine();
			// 创建画布
			createCanvas(el);
			// 处理数据
			data = param.data || [];
			// 开始画图
			self.update(data, -1);
			// 监听鼠标移入
			el.onmousemove = function(e) {
				var curIndex = -1;
				// 判断鼠标是否在圆环区域，在圆环上才进行重绘计算
				var x = e.pageX - getOffsetLeft(el), y =e.pageY - getOffsetTop(el);
				var distance = getDistance({x: x, y: y}, {x: ox, y: oy});
				if(total > 0 && distance < r && distance > r * 0.8 ) {					
					// 计算当前鼠标所属的数据域
					// 计算鼠标所在点与圆环中心点夹角，顺时针方向
					var mouseAngle = Math.atan2(y - oy, x - ox);
					if(mouseAngle < 0) {
						mouseAngle += 2 * Math.PI;
					}
					mouseAngle = mouseAngle - dAngle;
					if(mouseAngle < 0) {
						mouseAngle += 2 * Math.PI;
					} else if(mouseAngle > 2 * Math.PI) {
						mouseAngle -= 2 * Math.PI;
					}
					var anglePersent = mouseAngle/(2 * Math.PI);
					// 记录比例
					var curValue = 0;
					// 遍历数据
					for(var i=0; i<data.length; i++) {
						curValue += (data[i].value - 0);
						if(curValue/total > anglePersent) {
							curIndex = i;
							if(curIndex !== mouseIndex) {
								mouseIndex = curIndex;
								// 开始画图
								self.update(data, mouseIndex);
							}
							break;
						}
					}
				} else {
					curIndex = -1;
					if(curIndex !== mouseIndex) {
						mouseIndex = curIndex;
						self.update(data, mouseIndex);
					}
				}
			}
		}
		
		// 创建dom
		function createDom(id) {
			var box = document.getElementById(id);
			var wrap = document.createElement('div');
			wrap.style.height = '100%';
			wrap.style.position = 'relative';
			box.appendChild(wrap);
			var el = document.createElement('div');
			el.style.height = '100%';
			wrap.appendChild(el);
			// 创建图例
			var legnedWrap = document.createElement('div');
			legnedWrap.style.position = 'absolute';
			legnedWrap.style.fontSize = legend.text.fontSize;
			legnedWrap.style.left = '50%';
			legnedWrap.style.transform = 'translate(-50%, 0)';
			if(legend.position === 'top' || legend.position === 'bottom') {				
				legnedWrap.style[legend.position] = '1em';
//				wrap.style['padding-' + legend.position] = '1.5em';
			}
			legend.dom = legnedWrap;
			wrap.appendChild(legnedWrap);
			return el;
		}
		
		// 计算折线长度
		function getLine() {
			valueLine.line1.length = r * 0.2;
			valueLine.line2.length = r * 0.05;
		}
		
		// 计算两点间的距离
		function getDistance(p1, p2) {
			var dx = p1.x - p2.x;
			var dy = p1.y - p2.y;
			return Math.sqrt(dx * dx + dy * dy);
		}
		
		DrawCircle.prototype.update = function(d, index) {
			if(index === undefined) {
				index = -1;
			}
			data = d;
			// 圆弧开始值
			var start = 0;
			// 圆弧结束值
			var end = 0;
			// 总计
			total = 0;
			
			if(ctx) {
				ctx.clearRect(0, 0, width, height);
			}
			
			for(var i=0; i<data.length; i++) {
				total += data[i].value;
			}
			// 画数据圆环
			for(var i=0; i<data.length; i++) {
				end = start + data[i].value/total;
				drawCircleForData(data[i], start, end, total, i === index);
				start = end;
			}
			clearArcFun(ox, oy, r * or, ctx);
			// 画中心白色填充
			if(index > -1) {				
				createText({
					ctx: ctx,
					x: ox,
					y: oy,
					fontSize: centerLabel.fontSize,
					color: centerLabel.color,
					position: 'center',
					text: data[index].name || ''
				});
			}
			// 画legend
			legend.dom.innerHTML = '';
			if(legend.show) {
				var legendStr = '';
				var circleStyle = 'width: .7em;height: .7em;vertical-align: middle;display: inline-block;-o-border-radius: 100%;-moz-border-radius: 100%;-ms-border-radius: 100%;-webkit-border-radius: 100%;border-radius: 100%;margin-right: .6em;'
				for(var i=0; i<data.length; i++) {
					var color = createGradient(data[i].colors[0], data[i].colors[1]);
					legendStr += '<span style="margin: 0 0.5em;color: ' + legend.text.color + '"><span style="' + circleStyle + color + '"></span>' + data[i].name + '</span>'
				}
				legend.dom.innerHTML = legendStr;
			}
		}
		
		// 创建颜色渐变样式
		function createGradient(start, end) {
			var str = 'background: ' + start + ';' +
					  'background: -moz-linear-gradient(top,  ' + start + ' 0%, ' + end + ' 100%);' +
					  'background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,' + start + '), color-stop(100%,' + end + '));' +
					  'background: -webkit-linear-gradient(top,  ' + start + ' 0%,' + end + ' 100%);' +
					  'background: -o-linear-gradient(top,  ' + start + ' 0%,' + end + ' 100%);' +
					  'background: -ms-linear-gradient(top,  ' + start + ' 0%,' + end + ' 100%);' +
					  'background: linear-gradient(to bottom,  ' + start + ' 0%,' + end + ' 100%);' +
					  'filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' + start + '", endColorstr="' + end + '",GradientType=0 );';
			return str;
		}
		
		// 画出每天数据的弧
		function drawCircleForData(data, start, end, total, flag) {
			// flag表示鼠标是否在当前环区域
			// 计算切分份数
			var count = Math.ceil(data.value/total * counts);
			var colors = data.colors;
			var colors0 = colors[0].replace('rgb(', '').replace(')', '').split(',');
			var colors1 = colors[1].replace('rgb(', '').replace(')', '').split(',');
			var dr = (colors1[0] - colors0[0])/count;
			var dg = (colors1[1] - colors0[1])/count;
			var db = (colors1[2] - colors0[2])/count;
			
			var d = (end - start) / count;
			// 当前数据域对应弧半径
			var cr = flag ? r * 1.02 : r;
			// 将数据切分
			for(var i=0; i<count; i++) {
				var color = 'rgb(' + Math.ceil(colors0[0] - 0 + dr * i) + ', ' + Math.ceil(colors0[1] - 0 + dg * i) + ', ' + Math.ceil(colors0[2] - 0 + db * i) + ')';
				draw(cr, start + i * d, start + (i + 1) * d, color, i + 1 < count);
				if(i === Math.ceil(count/2)) {
					// 显示文字
					var text = Math.round(data.value/total * 100) + '%';
					// 创建折线，指向数据值
					createTarget((start + i * d) * 2 * Math.PI + dAngle, text);
				}
			}
		}
		
		// 创建中心文本
		function createText(param) {
			var ctx = param.ctx;
			ctx.beginPath();
			ctx.font = param.fontSize + 'px PingFangSC-Regular';
			ctx.fillStyle = param.color;
			ctx.textAlign = param.position || 'center';
			ctx.textBaseline = 'middle';
			ctx.fillText(param.text, param.x, param.y);
			ctx.fill();
			ctx.closePath();
		}
		
		// 创建折线，指向数据值
		function createTarget(angle, text) {
			var cos = Math.cos(angle);
			var sin = Math.sin(angle);
			// 计算x，y轴
			var dx = cos * r * 0.9;
			var dy = sin * r * 0.9;
			var oPoint = {
				x: dx + ox,
				y: dy + oy
			}
			// 计算第一节折线终点，即折线拐点
			var cPoint = {
				x: valueLine.line1.length * cos + oPoint.x,
				y: valueLine.line1.length * sin + oPoint.y
			}
			// 计算终点坐标
			var tPoint = {
				x: cPoint.x + (cos > 0 ? valueLine.line2.length : -valueLine.line2.length),
				y: cPoint.y
			}
			
			ctx.beginPath();
			ctx.moveTo(oPoint.x, oPoint.y);
			ctx.lineTo(cPoint.x, cPoint.y);
			ctx.lineTo(tPoint.x, tPoint.y);
			ctx.lineWidth = 1;          //设置线宽状态
			ctx.strokeStyle = valueLine.color ;  //设置线的颜色状态
			ctx.stroke();
			ctx.closePath();
			
			ctx.beginPath();
			ctx.font = valueLine.text.fontSize + 'px PingFangSC-Regular';
			ctx.fillStyle = valueLine.color;
			ctx.textAlign = cos < 0 ? 'right' : 'left';
			ctx.textBaseline = 'middle';
			ctx.fillText(' ' + text + ' ', tPoint.x, tPoint.y);
			ctx.fill();
			ctx.closePath();
		}
		
		// canvas画圆
		function draw(r, start, end, color, flag) {
			// flag 表示是否需要叠加渲染交界处，目前最后一个片段就不渲染了
			ctx.beginPath();
           	ctx.moveTo(ox, oy);
           	if(flag) {
           		ctx.arc(ox, oy, r, start * 2 * Math.PI + dAngle, end * 2 * Math.PI + 0.01 + dAngle, false);
           	} else {           		
           		ctx.arc(ox, oy, r, start * 2 * Math.PI + dAngle, end * 2 * Math.PI + dAngle, false);
           	}
           	ctx.closePath();
           	ctx.fillStyle = color;
           	ctx.fill();
		}
		
		// 创建一个canvas标签
		function createCanvas(wrap) {
			var canvas = document.createElement('canvas');
			ctx = canvas.getContext('2d');
			canvas.width = width;
			canvas.height = height;
			wrap.appendChild(canvas);
		}
		
		// 计算圆弧半径
		function getRadius(radius) {
			if(radius) {
				var tr = radius;
				var tor = or;
				var f = false;
				if(radius instanceof Array) {
					tr = radius[0];
					if(radius.length > 1) {
						tor = radius[1];
						f = true;
					}
				}
				
				var type = typeof tr;
				if(type === 'number') {
					r = tr;
				} else if(type === 'string') {
					if(tr.indexOf('%') > -1) {
						var k = Math.min(width, height);
						r = k * parseFloat(tr) / 100;
					} else {
						r = parseFloat(tr);
					}
				}
				if(f) {
					var typeo = typeof tor;
					if(typeo === 'number') {
						or = typeo/r;
					} else if(typeo === 'string') {
						if(tor.indexOf('%') > -1) {
							var k = Math.min(width, height);
							or = (k * parseFloat(tor) / 100)/r;
						} else {
							or = parseFloat(tor)/r;
						}
					}
				}
			}
		}
		
		// 计算中心点
		function getCenterPoint() {
			// 中心坐标点
			ox = width/2;
			oy = height/2;
			// 中心点坐标传入形式：['10', '10'], ['10%', '10%']，
			if(param.center) {
				if(param.center instanceof Array && param.center.length === 2) {
					if(typeof param.center[0] === 'string' && param.center[0].indexOf('%') > -1) {
						ox = width * parseFloat(param.center[0])/100;
					} else {
						ox = param.center[0];
					}
					if(typeof param.center[1] === 'string' && param.center[1].indexOf('%') > -1) {
						oy = height * parseFloat(param.center[1])/100;
					} else {
						oy = param.center[1];
					}
				}
			}
		}
		
		// 随机生成颜色
		function getRandomColor(){    
		    return  '#' + (function(color){    
		        return (color +=  '0123456789abcdef'[Math.floor(Math.random()*16)])    
		        && (color.length == 6) ?  color : arguments.callee(color);    
		    })('');    
		}
		
		//(x,y)为要清除的圆的圆心，r为半径，cxt为context
		function clearArcFun(x,y,r,cxt){   
			 var stepClear=1;//别忘记这一步  
		     clearArc(x,y,r);
			 function clearArc(x,y,radius){
			     var calcWidth=radius-stepClear;  
			     var calcHeight=Math.sqrt(radius*radius-calcWidth*calcWidth);  
			    	
			     var posX=x-calcWidth;  
			     var posY=y-calcHeight;  
				                      
			     var widthX=2*calcWidth;  
			     var heightY=2*calcHeight;  
				                      
			     if(stepClear<=radius){  
			         cxt.clearRect(posX,posY,widthX,heightY);  
			         stepClear+=1;  
			         clearArc(x,y,radius);  
			     }  
			 }  
		}
		
		function getOffsetLeft(obj){
            var tmp = obj.offsetLeft;
            var node= obj.offsetParent;
            while(node!= null){
            tmp += node.offsetLeft;
                node= node.offsetParent;
            }
            return tmp;
        }
   
      
		function getOffsetTop(obj){
           var tmp = obj.offsetTop;
           var node= obj.offsetParent;
           while(node!= null){
                tmp += node.offsetTop;
               node= node.offsetParent;
           }
           return tmp;
        }
		
		return new DrawCircle(param);
	}
	
	window.drawCircle = drawCircle;
})(window);
