"use strict";
window.onload = function() {

//======================================================================
// 开始定义Dictionary
//======================================================================
  var Dictionary=function ()
  {
    this.initialize.apply(this, arguments);
  }
  Dictionary.prototype.constructor = Dictionary;
  Dictionary.prototype.initialize= function (id){
    this._data=Object.create(Array.prototype);
    this.Count=this._data.length;
    this.Keys=Object.create(Array.prototype);
    this.Values=Object.create(Array.prototype);
  }
  Dictionary.prototype.contains=function (key) {
    return this.Keys.indexOf(key)>-1;
  }
  Dictionary.prototype.containsValue=function (value) {
    return this.Values.indexOf(value)>-1;
  }
  Dictionary.prototype.addItem=function (key,value) {
    this._data[key]=value;
    this.Count++;
    this.Keys.push(key);
    this.Values.push(value);
  }
  Dictionary.prototype.setItem=function (key,value) {
    if(this.Keys.indexOf(key)>-1)
    {
      this._data[key]=value;
      this.Keys.splice(this.Keys.indexOf(key),1,key);
      this.Values.splice(this.Keys.indexOf(key),1,value);
    }
    else throw `this key '${key}' is not found from Dictionary.`;
  }
  Dictionary.prototype.getItem=function (key) {
    return this._data[key];
  }
  Dictionary.prototype.removeItem=function (key) {
    this.Count--;
    this.Keys.splice(this.Keys.indexOf(key), 1);
    this.Values.splice(this.Values.indexOf(this._data[key]),1);
    delete this._data[key];
  }
//======================================================================
// 结束定义Dictionary
//======================================================================

var writeLine=function (contents,selector="p") {
  let container=document.querySelector(selector);
  container.innerHTML+=`>> ${contents}<br \\>`;
}
//使用范例
  writeLine(`首先我们创建Dictionary对象:var dic=new Dictionary();`);
  var dic=new Dictionary();
  writeLine(`可以使用addItem(key,value)方式给实例添加项目:dic.addItem("小李",15);dic.addItem("小张",20);`);
  dic.addItem("小李",15);
  dic.addItem("小张",20);
  writeLine(`然后使用getItem(key)获取值,获取如下:dic.getItem("小李");`);
  writeLine(`<span>当前小李值:${dic.getItem("小李")}.当前小张值:${dic.getItem("小张")}</span>`);
  writeLine(`<span>当前数目:${dic.Count}.是否包含小张:${dic.contains("小张")}</span>`);
  writeLine(`setItem(key,value)设置值,如:dic.setItem("小李",25);`);
  dic.setItem("小李",25);
  writeLine(`设置小李值为25后结果如下:`);
  writeLine(`<span>当前小李值:${dic.getItem("小李")}.当前小张值:${dic.getItem("小张")}</span>`);
  writeLine(`<span>当前数目:${dic.Count}.是否包含小张:${dic.contains("小张")}</span>`);
  writeLine(`removeItem(key)移除项目,如:dic.removeItem("小张");`);
  dic.removeItem("小张");
  writeLine(`删除小张后结果如下:`);
  writeLine(`<span>当前小李值:${dic.getItem("小李")}.当前小张值:${dic.getItem("小张")}</span>`);
  writeLine(`<span>当前数目:${dic.Count}.是否包含小张:${dic.contains("小张")}</span>`);
  writeLine(`==============================`);
  writeLine(`Dictionary属性`);
  writeLine(`_data : 当前实例的数据`);
  writeLine(`Count : 当前实例的项目数`);
  writeLine(`Keys : 当前实例的键的数组`);
  writeLine(`Values : 当前实例的值的数组`);
  writeLine(`Dictionary方法`);
  writeLine(`addItem(key,value) : 增加当前实例项目 key:键(var),value:值(var)`);
  writeLine(`getItem(key) : 根据 key:键(var) 获取当前实例项目`);
  writeLine(`setItem(key,value) : 设置当前实例项目 key:键(var),value:值(var)`);
  writeLine(`removeItem(key) : 根据 key:键(var) 移除当前实例项目`);
  writeLine(`contains(key) : 当前实例是否包含 key:键(var) 的项目`);
  writeLine(`containsValue(value) : 当前实例是否包含 value:值(var) 的项目`);
}
