(function ($) {
	var methods = {
		init: function (options) {
			var settings = $.extend({
				length: 300,
				unit: 'px'
			}, options);

			return this.each(function () {
				var box = $(this);
				if(box.data('HexagonBg')){
					return;
				}

				var ch = settings.length / Math.sqrt(3);
				var w100 = settings.length;
				var top = (w100 - ch) / 2;

				function getStr(num){
					return num + settings.unit;
				}

				var bgStr = 'url('+box.data('bg')+')';

				box.css({
					width: getStr(w100),
					height: getStr(w100),
					position: 'relative'
				})

				// 创建子元素
				var cont0 = $('<div><div></div></div>');
				cont0.css({
					width: getStr(w100),
					height: getStr(ch),
					position: 'absolute',
					left: 0,
					top: getStr(top),
					overflow: 'hidden'
				});
				cont0.find('div').css({
					width: getStr(w100),
					height: getStr(w100),
					position: 'absolute',
					left: 0,
					top: getStr(-top),
					background: bgStr + ' center center no-repeat',
					backgroundSize: 'auto ' + getStr(w100),
					transform: 'scale(1.3)'
				});


				var cont1 = cont0.clone()
				cont1.css({
					transform: 'rotate(60deg)'
				}).find('div').css({
					transform: 'rotate(-60deg) scale(1.3)',
					transformOrigin: 'center'
				});

				var cont2 = cont0.clone()
				cont2.css({
					transform: 'rotate(-60deg)'
				}).find('div').css({
					transform: 'rotate(60deg) scale(1.3)',
					transformOrigin: 'center'
				});

				box.append(cont0);
				box.append(cont1);
				box.append(cont2);

				box.data({
					HexagonBg:1
				})
			});
		},
		remove: function(){
			return this.each(function () {
				if($(this).data('HexagonBg')){
					console.log($(this).data('HexagonBg'))
					$(this).html('');
					$(this).removeData();
				}
			})
		}
	};
	$.fn.HexagonBg = function (method) {
		if (methods[method]) {
			return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
		} else if (typeof method === 'object' || !method) {
			return methods.init.apply(this, arguments);
		} else {
			$.error('Method' + method + 'does not exist on jQuery.HexagonBg');
		}
	};

})(jQuery);