const randerStep = (initData) => {
    const { id, className = '', stepData = [] } = initData;
    const boxName = className ? className : 'step-bar' + Math.ceil(Math.random() * 100000);
    const style = ` <style>
                    .${boxName}{
                    display: flex;
                    margin:40px 80px;
                }
                .${boxName} .step-item {
                    display: flex;
                    width:100%;
                }

                .${boxName} .step-item .step-icon {
                    display: flex;
                    width: 24px;
                    height: 20px;
                    border-radius: 999999px;
                    border: 1px solid #000;
                    justify-content: center;
                    align-items: center;
                    margin: 0 10px;
                    box-sizing: border-box;
                    font-size:12px;
                }
                .${boxName} .step-item .step-icon-num-i {
                    background: #1E80FF;
                    border-color:#1E80FF;
                    color:#fff;
                }
                .${boxName} .step-content {
                    width: 100%;
                }
                .${boxName} .step-content .step-title {
                    display:flex;
                }
                .${boxName} .step-content .step-title span{
                    white-space: nowrap;
                }
                .${boxName} .step-content .step-title hr{
                    width: 100%;
                    height: 1px;
                    border: none;
                    background: #000;
                }
                .${boxName} .step-item:last-child .step-content .step-title hr{
                    display:none
                }
				.${boxName} .step-icon.step-icon-false{
					background:red;
					border-color:red;
					color:#fff
				}
            </style>`;
    let forHtml = '';
    stepData.forEach((item, index) => {
        forHtml += `<div class="step-item">`;
        if (item.state === true) {
            forHtml += ` <div class="step-icon step-icon-true">&#10003</div>`
        } else if (item.state === false) {
            forHtml += ` <div class="step-icon step-icon-false">&#10005</div>`
        } else {
            forHtml += `<div class="${item.state === 'index-i' ? 'step-icon step-icon-num-i' : 'step-icon step-icon-num-o'}">${index + 1}</div>`
        }
        forHtml += ` <div class="step-content">
            <div class="step-title">
                <span>${item.title || '--'}</span>
                <hr>
            </div>
                <div class="step-info">${item.desc}</div>
            </div>
        </div>`
    });
    const html = `<div class="${boxName}">${forHtml}</div>`;
    document.getElementById(id).innerHTML = html + style;
}