var language = 'language';
/**
 * 全局CSS存储
 */
var css = {};
/**
 * 全局JS存储
 */
var js = {};
/**
 * 语言配置工具类
 */
var defaulthtmlJSON = {
    "lang": document.getElementsByTagName("html")[0].getAttribute("lang") || "default",
    "title": document.title,
    "body": {},
    "js": {},
    "css": {}
};
var defaulthtmllangtag = "default";
var LangUtil = {
    /**
     * 如果不刷新则无法更新onload加载的事件，将修改语言切换为这个
     */
    reloadPageAndChangeLang: function(lang) {
        StorageUtil.set(language, lang);
        location.reload();
    },
    /**
     * 修改语言
     */
    changeLang: function(lang) {

        var json = {};
        if (defaulthtmllangtag != lang && "" != lang) {
            //先获取HTML中自带的lang名称
            var htmllang = document.getElementsByTagName("html")[0].getAttribute("lang");
            if (null == lang || "" == lang || htmllang == lang) {
                return;
            }
            Ajax.get({
                url: 'language/' + lang + '.json',
                async: false,
                success: function(date) {
                    json = JSON.parse(date)
                },
                error: function(error) {
                    StorageUtil.set(language, "");
                    LangUtil.alert("langErr", "获取语言文件失败，无法切换");
                    console.log(error);
                }
            });
        } else {
            json = defaulthtmlJSON;
        }
        try {
            console.log(json);

            if (null != json) {
                //修改js使用时加载的数据
                js = json.js;
                //修改css使用时加载的数据
                css = json.css;
            }
            languageChange(json);
            StorageUtil.set(language, lang);
        } catch (error) {
            StorageUtil.set(language, "");
            LangUtil.alert("langErr", "获取语言文件失败，无法切换");
            console.log(error);
        }
    },
    alert: function(key, value) {
        alert(LangUtil.val(key, value));
    },
    //css替换 css:expression(LangUtil.css(key, value))
    //expression 是 css执行js代码使用的，使用css执行js代码达到替换效果
    css: function(key, value) {
        return css[key] ? css[key] : value;
    },
    //js替换LangUtil.val(key, value)
    val: function(key, value) {
        return js[key] ? js[key] : value;
    }
};
/**
 * 进行语言的修改
 * @param {object} json 
 */
function languageChange(json) {
    if (null != json) {
        //修改语言标记
        document.getElementsByTagName("html")[0].setAttribute("lang", json.lang);
        // $("html").attr("lang", json.lang);
        //修改标题
        document.title = json.title;
        //修改body
        setDom("body", json.body);
    }
};
/**
 * 设置dom元素
 * @param {string} key 
 * @param {object} value 
 */
function setDom(key, value) {
    if (typeof value == 'object' && value) {
        for (var v1 in value) {
            [].forEach.call(document.querySelectorAll(key), function(dom) {
                if (dom.hasAttribute(v1)) {
                    if ("body" == key) {
                        defaulthtmlJSON.body[v1] = dom.getAttribute(v1);
                    } else {
                        if (!defaulthtmlJSON.body[key]) {
                            defaulthtmlJSON.body[key] = {};
                        }
                        if (!defaulthtmlJSON.body[key][v1]) {
                            defaulthtmlJSON.body[key][v1] = dom.getAttribute(v1);
                        }
                    }
                    dom.setAttribute(v1, value[v1]);
                } else {
                    if ("body" == key) {
                        setDom(v1, value[v1]);
                    } else {
                        setDom(key + ' ' + v1, value[v1]);
                    }
                }
            });
        }
    } else {
        [].forEach.call(document.querySelectorAll(key), function(dom) {
            if (!defaulthtmlJSON.body[key]) {
                defaulthtmlJSON.body[key] = dom.innerHTML;
            }
            dom.innerHTML = value;
        });
    }
};
/**
 * 实际最后使用的是jq的ajax，这个可以废弃了
 */
var Ajax = {
    get: function({ url, async, success, error }) {
        // XMLHttpRequest对象用于在后台与服务器交换数据   
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, async);
        xhr.onreadystatechange = function() {
            // readyState == 4说明请求已完成
            if (xhr.readyState == 4) {
                if (xhr.status == 200 || xhr.status == 304) {
                    success.call(this, xhr.responseText);
                } else {
                    console.log(xhr);
                    error.call(this, xhr.status, xhr.statusText);
                }
            }
        };
        xhr.send();
    },
    // datat应为'a=a1&b=b1'这种字符串格式，在jq里如果data为对象会自动将对象转成这种字符串格式
    post: function({ url, async, success, error }) {
        var xhr = new XMLHttpRequest();
        xhr.open("POST", url, async);
        // 添加http头，发送信息至服务器时内容编码类型
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function() {
            // readyState == 4说明请求已完成
            if (xhr.readyState == 4) {
                if (!fn) {
                    if (xhr.status == 200 || xhr.status == 304) {
                        success.call(this, xhr.responseText);
                    } else {
                        console.log(xhr);
                        error.call(this, xhr.status, xhr.statusText);
                    }
                } else {
                    fn.call(this, xhr.responseText);
                }
            }
        };
        xhr.send(data);
    }
};

/**
 * Cookies及Storage操作工具类 js直接操作Cookies
 */
var StorageUtil = {
    set: function(key, value, expiredays) {
        if (window.localStorage) {
            StorageUtil.setStorage(key, value, expiredays);
        } else {
            StorageUtil.setCookie(key, value, expiredays);
        }
    },
    get: function(key) {
        if (window.localStorage) {
            return StorageUtil.getStorage(key);
        } else {
            return StorageUtil.getCookie(key);
        }
    },
    /**
     * 写入cookies，如果使用文件管理器直接访问，无法写入cookies，需要域名或ip访问
     */
    setCookie: function(key, value, expiredays) {
        var exdate = new Date()
        exdate.setDate(exdate.getDate() + expiredays)
        document.cookie = key + "=" + escape(value) +
            ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString())
    },
    /**
     * 获取cookies
     */
    getCookie: function(key) {
        if (document.cookie.length > 0) {
            c_start = document.cookie.indexOf(key + "=")
            if (c_start != -1) {
                c_start = c_start + key.length + 1
                c_end = document.cookie.indexOf(";", c_start)
                if (c_end == -1) c_end = document.cookie.length
                return unescape(document.cookie.substring(c_start, c_end))
            }
        }
        return ""
    },
    //写入Storage
    setStorage: function(key, value, expiredays) {
        var exdate = new Date()
        exdate.setDate(exdate.getDate() + expiredays)
        try {
            localStorage.setItem(key, JSON.stringify({ data: value, time: ((expiredays == null) ? "" : exdate.toUTCString()) }));
        } catch (e) {
            //如果存储满了,就全部删掉
            localStorage.clear(); //全部删除
            localStorage.setItem(key, JSON.stringify({ data: value, time: ((expiredays == null) ? "" : exdate.toUTCString()) }));
        }
    },
    /**
     * 获取Storage
     */
    getStorage: function(key) {
        var data = localStorage.getItem(key);
        var dataObj = JSON.parse(data);
        if (dataObj) {
            if ("" != dataObj.time && new Date() > new Date(dataObj.time)) {
                localStorage.removeItem(key); //过期就清除key的值
                console.log('信息已过期');
            } else {
                return dataObj.data;
            }
        } else {
            return "";
        }
    }
};




//获取浏览器页面可见高度和宽度
var _PageHeight = document.documentElement.clientHeight,
    _PageWidth = document.documentElement.clientWidth;
//在页面未加载完毕之前显示的loading Html自定义内容
var _LoadingHtml = '<div id="loadingDiv" style="position:absolute;left:0;width:100%;height:' + _PageHeight + 'px;top:0;background:#f3f8ff;opacity:1;filter:alpha(opacity=80);z-index:10000;"></div>';
//呈现loading效果
document.write(_LoadingHtml);

var lang = StorageUtil.get(language) || navigator.language || navigator.userLanguage; //常规浏览器语言和IE浏览器
document.onreadystatechange = function() {
    //加载语言包 document.readyState type DocumentReadyState = "loading" | "interactive" | "complete";
    console.log(document.readyState);
    //此处，需要在加载jq的$(function(){})之前执行，在这个时候可以先初始化数据
    if (document.readyState == "interactive") {
        LangUtil.changeLang(lang, document.readyState);
    }
    if (document.readyState == 'complete') {
        // 加载完毕
        //语言包加载完成后才能显示界面，不然会有文字变动的情况
        var loadingMask = document.getElementById('loadingDiv');
        loadingMask.parentNode.removeChild(loadingMask);
    }
};