//I am kmh0228 , QQ:1150123276

//插件说明
/*
该插件使用的是面向对象，纯原生插件，使用时需要new出来一个对象
例如 var cube=new Cube(id,opts);
//opts参数：
opts:{
	borderLength:num 魔方边长, 默认240px
	vColor:color，魔方材料颜色 ,默认#999
	colors:[[][][][][][]]，魔方各个面的颜色，默认正常魔方的颜色
	order:num 魔方阶乘 ,默认3阶
	mouseSen 拖拽时鼠标灵敏度 , 默认0.5
	oneTime 转动一下时需要的毫秒时间，默认500
	oneTimeBatch 批量扭动时转动一下所需要的时间 默认200
	turnOn:true  是否在魔方上点击扭动 默认是
	turnArrowColor:pink; 箭头颜色,默认PINK
	cache:true  是否缓存魔方信息，以便下次打开此浏览器继续
	turnBack:fn   每次扭动后的毁掉函数，参数为扭动的轴列方向 {coor:,num:,dir:}
}

此对象的方法： 
常用：
	turn(coor,num,dir,comebackfn);//基础的扭动方法,参数coor：扭动那个轴方向的魔方，num：扭动这个轴的第几层的魔方，dir：方向,正方向turn 反方向false，combackfn:扭动完成后的回掉函数
	turn3(t);//仅限于3阶魔方的扭动，t可为 u,u',b,b'……(三阶魔方的指令，'是反方向的意思);
	turn3s(ts);//仅限于3阶魔方,ts是三阶魔方指令的组合。例如 var ts='uu\'bb\'lr\'f';注意字符串中的'要转义
	initColor();//初始化魔方最开始的样子。步数同步清零
	initL();//初始化魔方旋转的角度
	getFoots();//返回当前已经扭的步数
	random(n);//随机打乱魔方，n为随机打乱的步数。默认30步
	back();//撤销一步
	
不常用：
	delColor();//干掉颜色。只剩材料颜色
	setColor(colors);//自己设定颜色,colors为2维数组
	setMouseSen(n);//设置鼠标拖拽魔方的灵敏度
	setOneTime(time);//设置魔方扭动速度- 毫秒时间。
*/

function Cube(a, b) {
	this.id = a;
	this.container = document.getElementById(a);
	this.opts = b || {};
	this.order = this.opts.order || 3;
	this.borderLength = this.opts.borderLength || 240;
	this.boxBorderLength = parseInt(this.borderLength / this.order / 2) * 2;
	this.borderLength = this.boxBorderLength * this.order;
	this.vColor = this.opts.vColor || '#999';
	this.mouseSen = this.opts.mouseSen || 0.5;
	this.oneTime = this.opts.oneTime || 500;
	this.oneTimeBatch = this.opts.oneTimeBatch || 200;
	this.cache = typeof this.opts.cache == 'undefined' ? true : this.opts.cache;
	this.cacheinfo = this.getCache();
	this.turnOn = typeof(this.opts.turnOn) == 'undefined' ? true : this.opts.turnOn;
	this.turnArrowColor = this.opts.turnArrowColor || 'pink';
	this.turnBack = this.opts.turnBack;
	this.record = [];
	this.foots = this.cacheinfo.foots || 0;
	this.container.innerHTML = '';
	this.boxsData = [];
	this.boxsDataLength = Math.pow(this.order, 3);
	for (var i = 0; i < this.boxsDataLength; i++) {
		var c = {};
		c.dom = document.createElement('div');
		this.container.appendChild(c.dom);
		c.faces = [];
		for (var j = 0; j < 6; j++) {
			var d = document.createElement('div');
			c.dom.appendChild(d);
			c.faces.push(d)
		}
		c.x = c.intx = i % this.order;
		c.y = c.inty = (parseInt(i / this.order)) % this.order;
		c.z = c.intz = (parseInt(i / Math.pow(this.order, 2))) % this.order;
		this.boxsData.push(c)
	}
	this.turnOn && this.addArrow();
	this.initStyle();
	this.initColors = this.opts.colors || [
		['yellow'],
		['#fff'],
		['blue'],
		['green'],
		['red'],
		['orange']
	];
	this.colors = this.cacheinfo.colors || this.initColors;
	this.setColor(this.colors);
	this.containerMouseMove()
}
Cube.prototype.getCache = function() {
	if (!this.cache) return {};
	return JSON.parse(localStorage['cube' + this.id + this.order] || '{}')
}
Cube.prototype.setCache = function(a) {
	if (!this.cache) return;
	for (var b in a) {
		this.cacheinfo[b] = a[b]
	}
	localStorage['cube' + this.id + this.order] = JSON.stringify(this.cacheinfo)
};
Cube.prototype.addArrow = function() {
	var d = this.order;
	var b = this.order - 1;
	var e = [{
		y: 0
	}, {
		y: b
	}, {
		x: 0
	}, {
		x: b
	}, {
		z: b
	}, {
		z: 0
	}];
	var f = [{
		up: {
			coor: 'x',
			dir: 1
		},
		bottom: {
			coor: 'x',
			dir: 0
		},
		left: {
			coor: 'z',
			dir: 0
		},
		right: {
			coor: 'z',
			dir: 1
		}
	}, {
		up: {
			coor: 'x',
			dir: 0
		},
		bottom: {
			coor: 'x',
			dir: 1
		},
		left: {
			coor: 'z',
			dir: 1
		},
		right: {
			coor: 'z',
			dir: 0
		}
	}, {
		up: {
			coor: 'y',
			dir: 0
		},
		bottom: {
			coor: 'y',
			dir: 1
		},
		left: {
			coor: 'z',
			dir: 1
		},
		right: {
			coor: 'z',
			dir: 0
		}
	}, {
		up: {
			coor: 'y',
			dir: 1
		},
		bottom: {
			coor: 'y',
			dir: 0
		},
		left: {
			coor: 'z',
			dir: 0
		},
		right: {
			coor: 'z',
			dir: 1
		}
	}, {
		up: {
			coor: 'x',
			dir: 1
		},
		bottom: {
			coor: 'x',
			dir: 0
		},
		left: {
			coor: 'y',
			dir: 0
		},
		right: {
			coor: 'y',
			dir: 1
		}
	}, {
		up: {
			coor: 'x',
			dir: 0
		},
		bottom: {
			coor: 'x',
			dir: 1
		},
		left: {
			coor: 'y',
			dir: 1
		},
		right: {
			coor: 'y',
			dir: 0
		}
	}, ];
	for (var i = 0; i < 6; i++) {
		var g = this.getDomByPos(e[i]);
		for (var j = 0; j < g.length; j++) {
			if (parseInt(j / d) == 0) {
				g[j].faces[i].innerHTML += '<div class="arrow top" coor="' + f[i].up.coor + '" num="' + (j % d) + '" dir="' + f[i].up.dir + '"></div>'
			}
			if (parseInt(j / d) == b) {
				g[j].faces[i].innerHTML += '<div class="arrow bottom" coor="' + f[i].bottom.coor + '" num="' + (j % d) + '" dir="' + f[i].bottom.dir + '"></div>'
			}
			if (j % d == 0) {
				g[j].faces[i].innerHTML += '<div class="arrow left" coor="' + f[i].left.coor + '" num="' + parseInt(j / d) + '" dir="' + f[i].left.dir + '"></div>'
			}
			if (j % d == b) {
				g[j].faces[i].innerHTML += '<div class="arrow right" coor="' + f[i].right.coor + '" num="' + parseInt(j / d) + '" dir="' + f[i].right.dir + '"></div>'
			}
		}
	}
	var h = parseInt(this.boxBorderLength / 2);
	var k = parseInt(this.boxBorderLength / 4);
	var l = parseInt(this.boxBorderLength / 5);
	var m = this.container.getElementsByClassName('arrow');
	var n = this.container.getElementsByClassName('top');
	var o = this.container.getElementsByClassName('bottom');
	var p = this.container.getElementsByClassName('left');
	var q = this.container.getElementsByClassName('right');
	for (var i = 0; i < m.length; i++) {
		m[i].style.position = 'absolute';
		m[i].style.cursor = 'pointer';
		m[i].style.display = 'none';
		m[i].style.width = '0';
		m[i].style.height = '0'
	}
	var r = n.length;
	for (var i = 0; i < r; i++) {
		n[i].style.borderLeft = n[i].style.borderRight = h / 2 + 'px solid transparent';
		n[i].style.borderBottom = l + 'px solid ' + this.turnArrowColor;
		n[i].style.left = k + 'px';
		n[i].style.top = 0;
		o[i].style.borderLeft = o[i].style.borderRight = h / 2 + 'px solid transparent';
		o[i].style.borderTop = l + 'px solid ' + this.turnArrowColor;
		o[i].style.left = k + 'px';
		o[i].style.bottom = 0;
		p[i].style.borderTop = p[i].style.borderBottom = h / 2 + 'px solid transparent';
		p[i].style.borderRight = l + 'px solid ' + this.turnArrowColor;
		p[i].style.top = k + 'px';
		p[i].style.left = 0;
		q[i].style.borderTop = q[i].style.borderBottom = h / 2 + 'px solid transparent';
		q[i].style.borderLeft = l + 'px solid ' + this.turnArrowColor;
		q[i].style.top = k + 'px';
		q[i].style.right = 0
	}
	for (var i = 0; i < this.boxsDataLength; i++) {
		var s = this.boxsData[i].faces;
		for (var j = 0; j < 6; j++) {
			s[j].onmouseenter = function() {
				var a = this.getElementsByClassName('arrow');
				var b = a.length;
				for (var j = 0; j < b; j++) {
					a[j].style.display = 'block'
				}
			};
			s[j].onmouseleave = function() {
				var a = this.getElementsByClassName('arrow');
				var b = a.length;
				for (var j = 0; j < b; j++) {
					a[j].style.display = 'none'
				}
			}
		}
	}
	var t = this;
	for (var i = 0; i < m.length; i++) {
		m[i].onclick = function() {
			var a = this.getAttribute('coor');
			var b = this.getAttribute('num');
			var c = this.getAttribute('dir');
			t.turn(a, b, Number(c))
		}
	}
}
Cube.prototype.initStyle = function() {
	var a = this.cacheinfo;
	var x = this.rotateX = a.x || 0;
	var y = this.rotateY = a.y || 0;
	var z = this.rotateZ = a.z || 0;
	this.container.style.width = this.container.style.height = this.borderLength + 'px';
	this.container.style.positon = 'relative';
	this.container.style.WebkitTransformStyle = 'preserve-3d';
	this.container.style.WebkitTransform = 'perspective(800px) rotateZ(' + z + 'deg) rotateY(' + y + 'deg) rotateX(' + x + 'deg)';
	for (var i = 0; i < this.boxsDataLength; i++) {
		this.boxsData[i].dom.style.position = 'absolute';
		this.boxsData[i].dom.style.width = this.boxsData[i].dom.style.height = this.boxBorderLength + 'px';
		this.boxsData[i].dom.style.left = this.boxsData[i].dom.style.top = (this.order / 2 - 0.5) * this.boxBorderLength + 'px';
		var x = this.boxsData[i].translateX = (this.boxsData[i].x + 0.5 - (this.order / 2)) * this.boxBorderLength;
		var y = this.boxsData[i].translateY = (this.boxsData[i].y + 0.5 - (this.order / 2)) * this.boxBorderLength;
		var z = this.boxsData[i].translateZ = (this.boxsData[i].z + 0.5 - (this.order / 2)) * this.boxBorderLength;
		var b = this.boxsData[i].rotateX = 0;
		var c = this.boxsData[i].rotateY = 0;
		var d = this.boxsData[i].rotateZ = 0;
		this.boxsData[i].dom.style.WebkitTransformStyle = 'preserve-3d';
		this.boxsData[i].dom.style.WebkitTransform = 'rotateX(' + b + 'deg) rotateY(' + c + 'deg) rotateZ(' + d + 'deg) translateZ(' + z + 'px) translate(' + x + 'px,' + y + 'px)';
		for (var j = 0; j < 6; j++) {
			this.boxsData[i].faces[j].style.position = 'absolute';
			this.boxsData[i].faces[j].style.top = this.boxsData[i].faces[j].style.left = 0;
			this.boxsData[i].faces[j].style.width = this.boxsData[i].faces[j].style.height = '100%';
			this.boxsData[i].faces[j].style.border = '2px solid ' + this.vColor;
			this.boxsData[i].faces[j].style.boxSizing = 'border-box';
			this.boxsData[i].faces[j].style.background = this.vColor;
			this.boxsData[i].faces[j].style.borderRadius = parseInt(this.boxBorderLength / 10) + 'px';
			var e = 0,
				ty = 0,
				tz = 0,
				b = 0,
				c = 0,
				d = 0;
			switch (j) {
			case 0:
				ty = -this.boxBorderLength / 2;
				b = 90;
				break;
			case 1:
				ty = this.boxBorderLength / 2;
				b = 90;
				break;
			case 2:
				e = -this.boxBorderLength / 2;
				c = 90;
				b = 90;
				break;
			case 3:
				e = this.boxBorderLength / 2;
				c = 90;
				b = 90;
				break;
			case 4:
				tz = this.boxBorderLength / 2;
				break;
			case 5:
				tz = -this.boxBorderLength / 2;
				break
			}
			var f = '';
			f += e ? 'translateX(' + e + 'px) ' : '';
			f += ty ? 'translateY(' + ty + 'px) ' : '';
			f += tz ? 'translateZ(' + tz + 'px) ' : '';
			f += b ? 'rotateX(' + b + 'deg) ' : '';
			f += c ? 'rotateY(' + c + 'deg) ' : '';
			f += d ? 'rotateZ(' + d + 'deg) ' : '';
			this.boxsData[i].faces[j].style.WebkitTransform = f
		}
	}
};
Cube.prototype.delColor = function() {
	for (var i = 0; i < this.boxsDataLength; i++) {
		var a = this.boxsData[i].faces;
		for (var j = 0; j < 6; j++) {
			a[j].style.backgroundColor = this.vColor
		}
	}
}
Cube.prototype.setColor = function(c) {
	var d = this;
	this.delColor();
	this.colors = c || (function() {
		var a = [];
		for (var i = 0; i < d.initColors.length; i++) {
			var b = d.initColors[i].slice(0);
			a.push(b)
		}
		return a
	})();
	for (i = 0; i < +6; i++) {
		if (!this.colors[i]) {
			this.colors[i] = this.colors[i - 1]
		}
		for (var j = 0; j < Math.pow(this.order, 2); j++) {
			if (!this.colors[i][j]) {
				this.colors[i][j] = this.colors[i][j - 1]
			}
		}
	}
	this.setCache({
		colors: this.colors
	});
	var b = this.order - 1;
	var e = [{
		y: 0
	}, {
		y: b
	}, {
		x: 0
	}, {
		x: b
	}, {
		z: b
	}, {
		z: 0
	}];
	for (var i = 0; i < 6; i++) {
		var f = this.getDomByPos(e[i]);
		for (var j = 0; j < f.length; j++) {
			f[j].faces[i].style.background = this.colors[i][j]
		}
	}
};
Cube.prototype.initColor = function() {
	this.foots = 0;
	this.setCache({
		foots: 0
	});
	this.record = [];
	this.setColor()
}
Cube.prototype.getDomByPos = function(a) {
	var b = [];
	var a = a || {};
	var x = /[\d+]/.test(a.x) ? a.x : 'all';
	var y = /[\d+]/.test(a.y) ? a.y : 'all';
	var z = /[\d+]/.test(a.z) ? a.z : 'all';
	for (var i = 0; i < this.boxsDataLength; i++) {
		if ((this.boxsData[i].x == x || x == 'all') && (this.boxsData[i].y == y || y == 'all') && (this.boxsData[i].z == z || z == 'all')) {
			b.push(this.boxsData[i])
		}
	}
	return b
};
Cube.prototype.drag = function(k, l, m, n) {
	if (!k) return;
	if (arguments.length == 2) {
		var m = l;
		l = null
	}
	var o = function(e) {
			var f = e || event;
			var g = f.clientX;
			var h = f.clientY;
			l && l();
			var i = function(a) {
					var b = a || event;
					var c = b.clientX;
					var d = b.clientY;
					m && m(c - g, d - h);
					g = c;
					h = d
				};
			document.addEventListener('mousemove', i);
			var j = function() {
					document.removeEventListener('mousemove', i);
					document.removeEventListener('mousemove', i);
					n && n();
					k.releaseCapture && k.releaseCapture()
				};
			document.addEventListener('mouseup', j);
			k.setCapture && k.setCapture();
			e.preventDefault()
		};
	k.addEventListener('mousedown', o)
};
Cube.prototype.containerMouseMove = function() {
	var e = this;
	this.oldRotateX = this.rotateX || 0;
	this.oldRotateY = this.rotateX || 0;
	this.oldRotateZ = this.rotateZ || 0;
	var f, scale2;
	var g = Math.PI / 180;
	this.drag(e.container, function() {}, function(a, b) {
		var c = e.rotateY % 360;
		if (c < 0) {
			c += 360
		}
		if (c > 180) {
			c = 360 - c
		}
		f = Math.cos(c * g);
		var d = e.rotateY % 360;
		if (d < 0) {
			d += 360
		}
		if (d > 270) {
			d = 540 - d
		} else if (d < 90) {
			d = 180 - d
		}
		scale2 = Math.sin(d * g);
		e.rotateY += (a * e.mouseSen);
		e.rotateX -= (b * e.mouseSen * f);
		if (e.rotateX > 45) {
			e.rotateX = 45
		} else if (e.rotateX < -45) {
			e.rotateX = -45
		}
		e.rotateZ -= (b * e.mouseSen * scale2);
		if (e.rotateZ > 45) {
			e.rotateZ = 45
		} else if (e.rotateZ < -45) {
			e.rotateZ = -45
		}
		e.setCache({
			x: e.rotateX,
			y: e.rotateY,
			z: e.rotateZ
		});
		e.container.style.WebkitTransform = 'perspective(800px) rotateY(' + e.rotateY + 'deg) rotateX(' + e.rotateX + 'deg) rotateZ(' + e.rotateZ + 'deg)'
	})
};
Cube.prototype.initL = function() {
	this.rotateX = this.rotateY = this.rotateZ = 0;
	this.setCache({
		x: 0,
		y: 0,
		z: 0
	});
	this.container.style.WebkitTransform = 'perspective(800px) rotateY(' + this.rotateY + 'deg) rotateX(' + this.rotateX + 'deg) rotateZ(' + this.rotateZ + 'deg)'
};
Cube.prototype.setMouseSen = function(n) {
	this.mouseSen = n
};
Cube.prototype.trunRightColorChange = function(a, n) {
	if (!a) return;
	var n = n || 1;
	var b = [];
	var c = this.order;
	var d = a.length;
	var e = a.slice(0);
	for (var i = 0; i < n; i++) {
		b = e.slice(0);
		for (var j = 0; j < d; j++) {
			var f = (j % c) * c + c - 1 - parseInt(j / c);
			e[j] = b[f]
		}
	}
	return e
};
Cube.prototype.trunTabX = function(a) {
	if (!a) return;
	var b = a.slice(0);
	var c = this.order;
	var d = a.length;
	var e = [];
	for (var i = 0; i < d; i++) {
		var f = (c - 1 - parseInt(i / c)) * c + (i % c);
		e[i] = b[f]
	}
	return e
};
Cube.prototype.trunTabY = function(a) {
	if (!a) return;
	var b = a.slice(0);
	var c = this.order;
	var d = a.length;
	var e = [];
	for (var i = 0; i < d; i++) {
		var f = parseInt(i / c) * c + (c - 1 - i % c);
		e[i] = b[f]
	}
	return e
};
Cube.prototype.reSetColorByTurnEnd = function(a, b, c) {
	var d = [];
	var e = this.order;
	var f = e * e;
	var g = ['上', '下', '左', '右', '前', '后'];
	for (var i = 0; i < e; i++) {
		d.push(i)
	}
	var h = this.colors[0].slice(0);
	var j = this.colors[1].slice(0);
	var k = this.colors[2].slice(0);
	var l = this.colors[3].slice(0);
	var o = this.colors[4].slice(0);
	var p = this.colors[5].slice(0);
	switch (a) {
	case 'x':
		if (c) {
			for (var i = 0; i < this.order; i++) {
				var n = Number(b) + e * i;
				this.colors[0][n] = o[n];
				this.colors[4][n] = this.trunTabX(j)[n];
				this.colors[1][n] = p[n];
				this.colors[5][n] = this.trunTabX(h)[n]
			}
			if (b == 0) {
				this.colors[2] = this.trunRightColorChange(this.colors[2], 3)
			}
			if (b == e - 1) {
				this.colors[3] = this.trunRightColorChange(this.colors[3], 3)
			}
		} else {
			for (var i = 0; i < this.order; i++) {
				var n = Number(b) + e * i;
				this.colors[4][n] = h[n];
				this.colors[1][n] = this.trunTabX(o)[n];
				this.colors[5][n] = j[n];
				this.colors[0][n] = this.trunTabX(p)[n]
			}
			if (b == 0) {
				this.colors[2] = this.trunRightColorChange(this.colors[2], 1)
			}
			if (b == e - 1) {
				this.colors[3] = this.trunRightColorChange(this.colors[3], 1)
			}
		}
		break;
	case 'y':
		if (c) {
			for (var i = 0; i < this.order; i++) {
				var m = Number(b) + e * i;
				var n = Number(b) * e + i;
				this.colors[4][n] = this.trunTabY(this.trunRightColorChange(k, 3))[n];
				this.colors[3][m] = this.trunRightColorChange(o, 1)[m];
				this.colors[5][n] = this.trunRightColorChange(this.trunTabY(l), 1)[n];
				this.colors[2][m] = this.trunRightColorChange(p, 1)[m]
			}
			if (b == 0) {
				this.colors[0] = this.trunRightColorChange(this.colors[0], 1)
			}
			if (b == e - 1) {
				this.colors[1] = this.trunRightColorChange(this.colors[1], 1)
			}
		} else {
			for (var i = 0; i < this.order; i++) {
				var n = Number(b) + e * i;
				var m = Number(b) * e + i;
				this.colors[2][n] = this.trunTabY(this.trunRightColorChange(o, 3))[n];
				this.colors[4][m] = this.trunRightColorChange(l, 3)[m];
				this.colors[3][n] = this.trunRightColorChange(this.trunTabY(p), 1)[n];
				this.colors[5][m] = this.trunRightColorChange(k, 3)[m]
			}
			if (b == 0) {
				this.colors[0] = this.trunRightColorChange(this.colors[0], 3)
			}
			if (b == e - 1) {
				this.colors[1] = this.trunRightColorChange(this.colors[1], 3)
			}
		}
		break;
	case 'z':
		if (c) {
			for (var i = 0; i < this.order; i++) {
				var m = Number(b) * e + i;
				this.colors[0][m] = this.trunTabY(k)[m];
				this.colors[2][m] = j[m];
				this.colors[1][m] = this.trunTabY(l)[m];
				this.colors[3][m] = h[m]
			}
			if (b == 0) {
				this.colors[5] = this.trunRightColorChange(this.colors[5], 3)
			}
			if (b == e - 1) {
				this.colors[4] = this.trunRightColorChange(this.colors[4], 3)
			}
		} else {
			for (var i = 0; i < this.order; i++) {
				var m = Number(b) * e + i;
				this.colors[2][m] = this.trunTabY(h)[m];
				this.colors[1][m] = k[m];
				this.colors[3][m] = this.trunTabY(j)[m];
				this.colors[0][m] = l[m]
			}
			if (b == 0) {
				this.colors[5] = this.trunRightColorChange(this.colors[5], 1)
			}
			if (b == e - 1) {
				this.colors[4] = this.trunRightColorChange(this.colors[4], 1)
			}
		}
		break
	}
	this.setColor(this.colors)
};
Cube.prototype.setOneTime = function(n) {
	this.oneTime = n
};
Cube.prototype.setOneTimeBatch = function(n) {
	this.oneTimeBatch = n
};
Cube.prototype.turn = function(a, b, c, d) {
	this.runing = this.runing || false;
	if (this.runing) return;
	var b = b || 0;
	if (b > this.order - 1) return;
	this.runing = true;
	if (c == false) {
		var c = false
	} else {
		var c = true
	};
	this.foots++;
	this.setCache({
		foots: this.foots
	});
	var e = {};
	e[a] = b;
	var f = this.seletDoms = this.getDomByPos(e);
	var n = 0;
	var g = f.length;
	var h = this;

	function transend() {
		this.removeEventListener('transitionend', transend, false);
		this.style.transition = 'none';
		n++;
		if (n == g) {
			h.reSetColorByTurnEnd(a, b, c);
			for (var i = 0; i < g; i++) {
				f[i].dom.style.WebkitTransform = 'rotateZ(0deg) rotateY(0deg) rotateX(0deg)  translateZ(' + f[i].translateZ + 'px) translate(' + f[i].translateX + 'px,' + f[i].translateY + 'px)'
			}
			h.record.push({
				coor: a,
				num: b,
				dir: c
			});
			h.runing = false;
			h.turnBack && h.turnBack({
				coor: a,
				num: b,
				dir: c
			});
			d && d()
		}
	}
	for (var i = 0; i < g; i++) {
		f[i].dom.style.transition = this.oneTime / 1000 + 's all ease';
		var j = 0,
			dry = 0,
			drz = 0;
		var k = c ? 1 : -1;
		switch (a) {
		case 'x':
			j = 90 * k;
			break;
		case 'y':
			dry = 90 * k;
			break;
		case 'z':
			drz = 90 * k;
			break
		}
		f[i].dom.addEventListener('transitionend', transend, false);
		f[i].dom.style.WebkitTransform = 'rotateZ(' + drz + 'deg) rotateY(' + dry + 'deg) rotateX(' + j + 'deg)  translateZ(' + f[i].translateZ + 'px) translate(' + f[i].translateX + 'px,' + f[i].translateY + 'px)'
	}
};
Cube.prototype.turn3 = function(a, b) {
	if (this.order != 3) return;
	var b = b ||
	function() {};
	var c = {
		u: {
			'coor': 'y',
			num: 0,
			dir: true
		},
		u_: {
			'coor': 'y',
			num: 0,
			dir: false
		},
		d: {
			'coor': 'y',
			num: 2,
			dir: true
		},
		d_: {
			'coor': 'y',
			num: 2,
			dir: false
		},
		l: {
			'coor': 'x',
			num: 0,
			dir: true
		},
		l_: {
			'coor': 'x',
			num: 0,
			dir: false
		},
		r: {
			'coor': 'x',
			num: 2,
			dir: true
		},
		r_: {
			'coor': 'x',
			num: 2,
			dir: false
		},
		f: {
			'coor': 'z',
			num: 2,
			dir: true
		},
		f_: {
			'coor': 'z',
			num: 2,
			dir: false
		},
		b: {
			'coor': 'z',
			num: 0,
			dir: true
		},
		b_: {
			'coor': 'z',
			num: 0,
			dir: false
		}
	};
	var d = c[a.replace('\'', '_')];
	d && this.turn(d.coor, d.num, d.dir, b)
};
Cube.prototype.turn3s = function(b, c) {
	var b = b.replace(' ', '');
	var d = b.match(/\w\'?/g);
	var e = d.length;
	var f = 0;
	var g = this;
	var h = this.oneTime;
	this.oneTime = this.oneTimeBatch;

	function dg() {
		g.turn3(d[f], function() {
			f++;
			if (f < e) {
				var a = setTimeout(function() {
					clearTimeout(a);
					dg()
				}, 0)
			} else {
				g.oneTime = h;
				c && c()
			}
		})
	}
	if (e > 0) {
		dg()
	}
};
Cube.prototype.back = function() {
	var a = this;
	var b = this.record.pop();
	if (b) {
		this.turn(b.coor, b.num, !b.dir, function() {
			a.record.pop()
		})
	}
};
Cube.prototype.getFoots = function() {
	return this.foots
};
Cube.prototype.getRandom = function(a, b) {
	return parseInt(a + Math.random() * (b - a))
};
Cube.prototype.random = function(n) {
	var e = this;
	var n = n || 30;
	var i = 0;
	var f = this.oneTime;
	var g = this.order;
	var h = ['x', 'y', 'z'];
	var j = parseInt(1000 / n);
	this.oneTime = j < 50 ? 50 : j;

	function turn_random() {
		i++;
		if (i > n) {
			e.oneTime = f
		} else {
			var b = h[e.getRandom(0, 3)];
			var c = e.getRandom(0, g);
			var d = e.getRandom(0, 2);
			e.turn(b, c, d, function() {
				var a = setTimeout(function() {
					clearTimeout(a);
					turn_random()
				}, 0)
			})
		}
	}
	turn_random()
};