//图表1
var chartOne = echarts.init(document.getElementById('chartOne'), null, {renderer: 'svg'});
var chartOneOptions = {
	tooltip: {
		trigger: 'axis',
		axisPointer: {
			type: 'shadow',
            shadowStyle: {
                color: 'rgba(14,34,68,.5)',
                shadowColor: 'rgba(14,34,68,.1)',
                shadowBlur: 5
            }
		},
	},
	legend: {
		left: '0',
		align: 'left',
		top: '0',
		textStyle: {
			color: '#fff'
		},
	},
	grid: {
		top: '20%',
		left: '0',
		right: '3%',
		bottom: '5%',
		containLabel: true
	},
	xAxis: [{
		type: 'category',
		axisLine: {
			show: true,
			lineStyle: {
				type: 'solid',
				color: '#1aaed7',
				width: '2'
			}
		},
		axisTick: {
			"show": false
		},
		axisLabel: {
			color: '#1aaed7',
			width: 100
		},
		splitLine: {
			show: false
		},
		boundaryGap: false,
		data: ["周一", "周二", "周三", "周四", "周五"]

	}],

	yAxis: [{
		type: 'value',
		min: 0,
		max:120,
		splitNumber: 6,
		splitLine: {
			show: true,
			lineStyle: {
				color: '#0e2244'
			}
		},
		axisLine: {
			show: false,
		},
		axisLabel: {
			show: true,
			margin: 20,
			textStyle: {
				color: '#1aaed7',

			},
		},
		axisTick: {
			show: false,
		},
	}],
	series: [{
			name: '本周',
			type: 'line',
			showAllSymbol: true,
			symbol: 'circle',
			symbolSize: 10,
			lineStyle: {
				normal: {
					color: "#A582EA",
				},
			},
			label: {
				show: false
			},
			itemStyle: {
				color: "rgba(89,47,180,1)",
				borderColor: "rgba(89,47,180,.3)",
				borderWidth: 8
			},
			areaStyle: {
				normal: {
					color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
							offset: 0,
							color: 'rgba(89,47,180,0.8)'
						},
						{
							offset: 1,
							color: 'rgba(89,47,180,0)'
						}
					], false),
				}
			},
			data: [40, 30, 60, 70, 50]
		},
		{
			name: '上周',
			type: 'line',
			showAllSymbol: true,
			symbol: 'circle',
			symbolSize: 10,
			lineStyle: {
				normal: {
					color: "#2CABE3",
				},
			},
			label: {
				show: false
			},
			itemStyle: {
				color: "rgba(53,108,255,1)",
				borderColor: "rgba(53,108,255,.3)",
				borderWidth: 8
			},
			areaStyle: {
				normal: {
					color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
							offset: 0,
							color: 'rgba(43,58,155,0.8)'
						},
						{
							offset: 1,
							color: 'rgba(43,58,155,0)'
						}
					], false),
				}
			},
			data: [80, 60, 40, 90, 75]
		},
	]
};
chartOne.setOption(chartOneOptions);

//图表2
var colorList = [{
		type: 'linear',
		x: 0,
		y: 0,
		x2: 1,
		y2: 1,
		colorStops: [{
				offset: 0,
				color: '#3a74fe'
			},
			{
				offset: 1,
				color: '#1533e6'
			}
		],
		globalCoord: false
	},
	{
		type: 'linear',
		x: 0,
		y: 0,
		x2: 1,
		y2: 1,
		colorStops: [{
				offset: 0,
				color: '#1db6d9'
			},
			{
				offset: 1,
				color: '#149bce'
			}
		],
		globalCoord: false
	},
	{
		type: 'linear',
		x: 0,
		y: 0,
		x2: 1,
		y2: 1,
		colorStops: [{
				offset: 0,
				color: '#8841e0'
			},
			{
				offset: 1,
				color: '#7534d9'
			}
		],
		globalCoord: false
	}
]
var chartTwo = echarts.init(document.getElementById('chartTwo'));
var chartTwoOptions = {
	title: {
		text: '区域分布',
		left: 0,
		top: 0,
		textStyle: {
			fontSize: 18,
			color: '#fff',
			fontWeight: 'normal'
		}
	},
	legend: {
		type: "scroll",
		orient: 'vertical',
		left: '0',
		align: 'left',
		top: '18%',
		textStyle: {
			color: '#93dcfe'
		},
		itemWidth: 20,
		itemHeight: 5
	},

	tooltip: {
		trigger: 'item',
		formatter: "{b} : {c} ({d}%)"
	},
	series: [{
		type: 'pie',
		radius: '65%',
		startAngle: -90,
		center: ['50%', '65%'],
		data: [{
				value: 345,
				name: '住宅'
			},
			{
				value: 300,
				name: '商业区'
			},
			{
				value: 260,
				name: 'CBD'
			}
		],
		roseType: 'radius',
		label: {
			normal: {
				formatter: ['{c|日人流量}', '{b|{c}人}'].join('\n'),
				rich: {
					c: {
						color: '#fff',
						fontSize: 14,
						lineHeight: 5
					},
					b: {
						color: '#fff',
						fontSize: 14,
						height: 40
					}
				},
			}
		},
		labelLine: {
			normal: {
				lineStyle: {
					color: 'rgb(98,137,169)'
				},
				length: 10,
				length2: 20,

			}
		},
		itemStyle: {
			normal: {
				color: function(params) {
					return colorList[params.dataIndex]
				}
			}
		}
	}]
};
chartTwo.setOption(chartTwoOptions);

// 窗口变化
window.onresize = function () {
	chartOne.resize();
	chartTwo.resize();	
}