/**
 * @module $nr
 * @fileoverview 数字卡片滚动组件：$nr
 * @description 实现数字滚动效果，可通过简单的调整卡片样式适应各种场景，方便易用.
 * [查看对象方法]{@link $nr}
*  @version 0.4.4
 * @author LC
 * @example
 * // 初始化 
 * $nr.start("numRollId", "324,213");
 */
/** @namespace */
var $nr = {
    // 版本号
    version: "0.4.4",
    // 卡片滚动对象集合
    objs: {
        // x: {
        //     // 根元素
        //     root: null,
        //     // 根元素(jQuery对象)
        //     $root: null,
        //     // 单个卡片的高度
        //     offsetHeight: null,
        //     // 上下卡片间隔距离
        //     bottom: 0,
        //     // 卡片滚动时间
        //     rollTime: 0,
        // }
    },
    winResize: false,
    /**
     * @memberof $nr
     * @method 数字卡片滚动组件初始化方法 start
     * @param {string} id 容器ID
     * @param {string} str 滚动内容
     * @param {number=} bottom 上下卡片间的距离
     * @param {number=} rollTime 卡片滚动动画时间
     */
    start: function (id, str, bottom, rollTime) {
        var nrObj = this.objs[id];
        if (nrObj && nrObj.isInit) {
            // 滚动卡片
            this.startNums(nrObj, str);
            return;
        } else {
            nrObj = this.objs[id] = {};
        }
        var strs = this.getStrs(str);
        if (strs) {
            // 倒序排列,从左到右依次处理各个数字
            strs.reverse();
        } else {
            return;
        }
        nrObj.id = id;
        nrObj.bottom = bottom ? bottom: 4;
        nrObj.rollTime = rollTime ? rollTime: 1500;
        var root = nrObj.root = document.getElementById(id);
        nrObj.$root = $(nrObj.root);
        // 获取单个卡片高度
        nrObj.offsetHeight = parseFloat(this.getStyle(root, "height"));
        
        // 清空滚动区域内容
        root.innerHTML = "";
        var ulHtmls = "";
        // 拼接卡片元素
        var this_= this;
        strs.forEach(function (e, i) {
            ulHtmls = this_.getUlHtml(id, e, i) + ulHtmls;
        });
        // 设置滚动区域内容
        root.innerHTML = ulHtmls;
        nrObj.isInit = true;
        // 滚动卡片
        this.startNums(nrObj, str);
        // 添加窗口大小改变监听
        if (!this_.winResize) {
            this_.winResize = true;
            window.addEventListener('resize', function () {
                var obj = null
                for (var k in this_.objs) {
                    obj = this_.objs[k];
                    obj.offsetHeight = parseFloat(this_.getStyle(obj.root, "height"));
                    var ulDoms = obj.root.children;
                    var ulDom = null;
                    for (var i = 0; i < ulDoms.length; i++) {
                        ulDom = $(ulDoms[i]);
                        ulDom.stop().animate({
                            top: this_.getRollHeight(obj, ulDom.attr("cn"), ulDom.attr("cn"))
                        }, obj.rollTime);
                    }
                }
            })
        }
    },
    // 获取需要滚动的高度
    getRollHeight: function (nrObj, c, z) {
        c = parseInt(c);
        z = parseInt(z);
        var num = z >= c ? z : 10 + z;
        var oh =  - (nrObj.offsetHeight + nrObj.bottom) * num;
        // console.log(c, z, num, oh);
        return oh;
    },
    // 滚动卡片处理
    startNums: function (nrObj, str) {
        var strs = this.getStrs(str);
        if (strs) {
            // 倒序排列,从左到右依次处理各个数字
            strs.reverse();
        } else {
            return;
        }
        var ulDom = null;
        var this_ = this;
        var val = null
        for (var i = 0; i <strs.length; i++) {
            ulDom = $("#" + nrObj.id + "-dwRollUl" + i);
            val = strs[i];
            // 获取ul元素类型
            var ulDomType = ulDom.attr("t");
            // 验证是否为数值
            var isNum = this_.isNumber(val);
            // 该元素存在且类型为数值 && 当前处理的值为数值 满足时则执行动画,否重新获取ul元素
            // console.log(ulDomType, isNum);
            if (ulDomType == "num" && isNum) {
            } else {
                // console.log(ulDom, ulDom.attr("t"), isNumber(val));
                var ulHtml = this_.getUlHtml(nrObj.id, val, i);
                if (ulDomType) {
                    ulDom.replaceWith(ulHtml);
                } else {
                    nrObj.$root.prepend(ulHtml);
                }
            }
            // 重新获取元素 开启动画
            if (isNum) {
                ulDom = $("#" + nrObj.id + "-dwRollUl" + i);
                // console.log(ulDom.attr("cn"), val);
                if (ulDom.attr("cn") != val) {
                    // 如果与当前值不同,则滚动
                    this_.setAnimate(nrObj, this_, ulDom, ulDom.attr("cn"), val);
                    // 设置当前数字
                    ulDom.attr("cn", val);
                }
            }
        }
        // 删除多余的ul元素
        var childs = nrObj.$root.children();
        for (var i = strs.length; i<childs.length; i++) {
            ulDom = $("#" + nrObj.id + "-dwRollUl" + i);
            if (ulDom) {
                ulDom.remove();
            }
        }
    },
    // 设置动画
    setAnimate: function (nrObj, this_, ulDom, cn, z) {
        // console.log(nrObj);
        ulDom.animate({
            top: this_.getRollHeight(nrObj, cn, z)
        }, nrObj.rollTime, null, function () {
            // console.log(ulDom, z);
            // 回归到第一个数字
            ulDom.css("top", -(nrObj.offsetHeight + nrObj.bottom) * z + "px");
        });
    },

    // 初始化值数组 strs
    getStrs: function (str) {
        if (!str) return null;
        var strs = [];
        if (typeof str == "number") {
            strs = (str + "").split("");
        } else if (typeof str == "string") {
            strs = str.split("");
        } else if (typeof str == "object" && Array.isPrototypeOf(str)) {
            strs = str;
        }
        return strs.length > 0 ? strs : null;
    },
    // 根据索引值与索引 拼接ul元素
    getUlHtml: function (id, e, i) {
        var ul = "<ul id='" + id + "-dwRollUl" + i;
        if (this.isNumber(e)) {
            // 数值
            ul += "' t='num' cn = '0'>";
            var html = "";
            for (var x = 0; x< 10; x++) {
                html += "<li>" + x + "</li>";
            }
            ul += html + html;
        } else {
            // 非数值
            ul += "' t='other'>";
            ul += "<li>" + e + "</li>";
        }
        return ul + "</ul>";
    },
    // 判断是否为数字
    isNumber: function (n) {
        var x = parseInt(n);
        return x || x === 0;
    },
    // 获取样式
    getStyle: function (obj,attr) {
        // if (obj.currentStyle) {
            // ie8及更早的浏览器
        //     return obj.currentStyle[attr];
        // } else {
            return getComputedStyle(obj,false)[attr];
        // }        
    }
}