(function($, window, document, undefined) {
	var GameMap = function(element, options) {
        this.$element = $(element);
		
		if(options.grid_num_x < 3) options.grid_num_x = 3;
        if(options.grid_num_y < 3) options.grid_num_y = 3;
        this.options = $.extend({}, $.fn.gameMap.defaults, options, this.$element.data());
        this._init();
    };
	
	$.fn.gameMap = function(options) {
        var args = Array.apply(null, arguments);
        args.shift();
        this.each(function() {
            //edit by tyrone
            var $this = $(this),
                data = $this.data('GameMap');
            if (data) $this.removeData("GameMap");
            if (data){
                //edit by tyrone
                $this.data('GameMap');
                $this.removeData("GameMap");
            }
            $this.data('GameMap', new GameMap(this, options));
        });
    }
    $.fn.gameMap.defaults = {
        l : 0,
		r : document.documentElement.clientWidth || document.body.clientWidth,
		t : 0,
		b : document.documentElement.clientHeight || document.body.clientHeight,
		grid : true,/*是否吸附*/
		grid_num_x : 3,/*吸附网格数量*/
		grid_num_y : 3,/*吸附网格数量*/
		space:10,/*吸附网格间距*/
		x:0,/*吸附网格位置(第几个网格*/
		y:0,/*吸附网格间距(第几个网格*/
		itemClassName:'SortItem',/*内部可拖拽对象类名*/
		outsideItemClassName:'editItem',/*外部可拖入对象类名*/
    };
	
	
	GameMap.prototype = {
        constructor: GameMap,
        _init: function() {
			
			this.$items = this.$element.children('.'+this.options.itemClassName);
			
			this.itemsWidth = parseFloat(this.$items.css('width'));
			this.itemsHeight = parseFloat(this.$items.css('height'));
			
			this.$outsideItem = $(document).find('.'+this.options.outsideItemClassName);
			
			
			//在初始化位置前重设网格数量
			var self = this;
			this.$items.each(function(i){
				var left = parseFloat($(this).css('left'));
				var top = parseFloat($(this).css('top'));
				//self.options.space * (self.options.grid_num_x+1) + self.itemsWidth * self.options.grid_num_x + 'px');
				if(left >(self.options.space * (self.options.grid_num_x) + self.itemsWidth * (self.options.grid_num_x-1))){
					self.options.grid_num_x = Math.ceil((left-self.options.space))/(self.itemsWidth+self.options.space);
				}
				if(top >(self.options.space * (self.options.grid_num_y) + self.itemsHeight * (self.options.grid_num_y-1))){
					self.options.grid_num_y = Math.ceil((top-self.options.space))/(self.itemsHeight+self.options.space);
				}
			});
			self._parentSize();
			
			
			
			self._bindElement();/*绑定父类拖拽*/
			self._bindItems();/*绑定父类内的可移动元素Item*/
			
			self._initItems();/*初始化位置*/
			
			self._bindOutsideItems();/*绑定外部可拖拽的元素*/
			

        },
		_bindOutsideItems:function(){
			var self = this;
			self.outSideMouse = null;
			self.$outsideItem.each(function(i){
				
				$(this).on('dragstart',function(ev){
					//console.log('dragstart');
					self.currentOutSideItem = $(this);
				});
				$(this).on('mousedown',function(ev){
					//console.log(ev.offsetX);
					//console.log(ev.offsetY);
					self.outSideMouse = ev;
				});
			});
		},
		
		_bindElement:function(){
			var self = this;
			self.currentOutSideItem = null;
			
			self.$element.bind('drop',function(ev){
				console.log('drop');
				ev.preventDefault();
				var itemEle = self.currentOutSideItem;
				
				//复制一份拖拽对象
				var newItem = $(itemEle).clone();
				$(newItem).addClass(self.options.itemClassName);
				$(newItem).removeAttr("id");
				
				$(ev.target).append($(newItem));
				
				//新鼠标位置（鼠标在父类的位置）-拖拽时鼠标在拖拽对象的位置
				$(newItem).css('left',event.offsetX-self.outSideMouse.offsetX + 'px');
				$(newItem).css('top',event.offsetY-self.outSideMouse.offsetY + 'px');
				
				self._bindItems($(newItem));//重新绑定
				self._adsorbent($(newItem));//需要重新吸附


				self.$items = self.$element.children('.'+self.options.itemClassName);//刷新元素集合
				return false;//已复制一份，返回，不真正拖拽
			});
			
			self.$element.bind('dragover',function(ev){
				ev.preventDefault();
			});
		},
		isundefined:function(value){
			if (typeof(value) == "undefined")
			{
				return true;
			}
			return false;
		},
		_bindItems:function(obj){
			var self = this;
			var items = self.isundefined(obj) ? self.$items : obj;//设置默认值
			
			items.on('mousedown',function(ev){
				var oEvent = ev || event;
				var sentX = oEvent.clientX - parseFloat($(this).css('left'));
				var sentY = oEvent.clientY - parseFloat($(this).css('top'));
				var obj = this;
				document.onmousemove = function (ev){
					var oEvent = ev || event;

					var slideLeft = oEvent.clientX - sentX;
					var slideTop = oEvent.clientY - sentY;

					if(slideLeft <= self.options.l){
						//slideLeft = self.options.l;
					}
					if(slideLeft >= self.options.r){
						//slideLeft = self.options.r;
					}
					if(slideTop <= self.options.t){
						//slideTop = self.options.t;
					}
					if(slideTop >= self.options.b){
						//slideTop = self.options.b;
					}
					$(obj).css('left',slideLeft + 'px');
					$(obj).css('top',slideTop + 'px');
					
					
					
				}
				
				

				document.onmouseup = function (){
					document.onmousemove = null;
					document.onmouseup = null;
					self.$items.removeClass('gameMapSelect');
					$(obj).addClass('gameMapSelect');
					
					
					//吸附
					self._adsorbent(obj);
				}

				return false;
			});
			
		},
		_initItems:function(){
			var self = this;
			self.$items.each(function(i){
				self._adsorbent($(this));
			});
		},
		_adsorbent:function(obj){
			var self = this;
			if(self.options.grid){
				var centerx = parseFloat($(obj).css('left')) + self.itemsWidth/2;
				var centery = parseFloat($(obj).css('top')) + self.itemsHeight/2;
				
				var left_num = Math.ceil((centerx-self.options.space/2) / (self.itemsWidth+self.options.space))-1;
				var top_num = Math.ceil((centery-self.options.space/2) / (self.itemsHeight+self.options.space))-1;
				if(left_num>self.options.grid_num_x-1){
					left_num = self.options.grid_num_x-1;
				}
				
				if(top_num>self.options.grid_num_y-1){
					top_num = self.options.grid_num_y-1;
				}
				if(left_num==self.options.grid_num_x-1){
					self.options.grid_num_x++;
					self._parentSize();
				}
				
				if(top_num==self.options.grid_num_y-1){
					self.options.grid_num_y++;
					self._parentSize();
				}
				
				//$(obj).css('left',left_num *  self.itemsWidth + (left_num+1)*self.options.space + 'px');
				//$(obj).css('top',top_num *  self.itemsHeight + (top_num+1)*self.options.space + 'px');
				//动画
				$(obj).animate({
					top: top_num *  self.itemsHeight + (top_num+1)*self.options.space + 'px',
					left: left_num *  self.itemsWidth + (left_num+1)*self.options.space + 'px',
				}, 200);
			}
		},
		
		
		_parentSize:function(){
			var self = this;
			if(self.options.grid){
				//设置父类大小
				self.$element.css('width',self.options.space * (self.options.grid_num_x+1) + self.itemsWidth * self.options.grid_num_x + 'px');
				self.$element.css('height',self.options.space * (self.options.grid_num_y+1) + self.itemsHeight * self.options.grid_num_y + 'px');
				
				////设置父类网格大小
				self.$element.css('background-size',(self.itemsWidth+self.options.space)+"px "+(self.itemsHeight+self.options.space)+"px");
				self.$element.css('background-position',(self.options.space/2)+"px "+(self.options.space/2)+"px");
				self.$element.css('background-image','linear-gradient(90deg, rgba(50, 0, 0, 0.6) 2%, rgba(0, 0, 0, 0) 2%), linear-gradient(360deg, rgba(50, 0, 0, 0.6) 2%, rgba(0, 0, 0, 0) 2%)');
				self.$element.css('background-repeat','repeat');

				//background-repeat: repeat;
				
			}else{
				
			}
		},
	}
})(jQuery, window, document);
