/**
 * 
 * Effects Slide Plugin 
 * for JQuery
 * 
 * Official Site: http://www.dxenia.com/slideplugin.html
 * 
 * @author Tolga Arıcan (chaylock@msn.com)
 *
 */

Effects.Slide = {
	
	cur: 0,
	duration: 1200, // animation duration
	easing: "swing", // swing || linear
	sourceArr: null,
	eff_place: null,
	prevBtn: null,
	nextBtn: null,
	interval: null,
	intervalBool: false,
	intervalBtn: null,
	intervalDuration: 6000,
	
	/**
	 * Initialize Function
	 * 
	 * @param {Object} id
	 * @param {Object} arr
	 * @param {Object} buttons (optional)
	 */
	init: function(id, arr, buttons){
				
		Effects.Slide.sourceArr = arr;
		Effects.Slide.eff_place = $(id);
		
		Effects.errHandler("init: JQuery Slide Plugin Initialized");
		
		if (buttons) {
			Effects.Slide.setButtons(buttons.p, buttons.n, buttons.a);
		}
		else {
			setIntervalOptions(true);
		}
		
		Effects.Slide.slideMe(0);
	},
	
	
	/**
	 * Slide Function
	 * 
	 * @param {Object} direction (-1|0|1)
	 */
	slideMe: function(direction) {
				
		// Stop interval
		if (Effects.Slide.interval) clearInterval(Effects.Slide.interval);
		
		// Disable Buttons
		Effects.Slide.enableButtons(false);
		
		// Cursor for tracking
		Effects.Slide.cur += infoStrArr.length; // js negative modulo problem hack
		Effects.Slide.cur = (Effects.Slide.cur + direction) % infoStrArr.length ;
		
		// Current Text & Coming Text
		var txt = $.trim(Effects.Slide.eff_place.html());					
		var next_txt = infoStrArr[Effects.Slide.cur];
		var eff_width = Effects.Slide.eff_place.width()*direction*-1;
		
		// Text Animations
		Effects.Slide.eff_place.animate({
			
			marginLeft: eff_width + "px",
			opacity: 0
								
			}, Effects.Slide.duration, Effects.Slide.easing, function() { 
			
				Effects.Slide.eff_place.html(next_txt);
				Effects.Slide.eff_place.css("margin-left",-eff_width+"px");
				Effects.Slide.eff_place.animate({
				
						marginLeft: "0px",
						opacity: 1
											
					}, Effects.Slide.duration, Effects.Slide.easing, function() {
						
						Effects.Slide.enableButtons(true);
						
						// Start Interval (if it has been set)
						if (Effects.Slide.intervalBool)
							Effects.Slide.interval = setInterval(function(){ Effects.Slide.slideMe(1); },Effects.Slide.intervalDuration);
				});
			});
	},
	
	/**
	 * Sets Navigation Buttons
	 * 
	 * @param {Object} prev
	 * @param {Object} next
	 * @param {Object} interval
	 */
	setButtons: function(prev, next, interval){
		
		if ((prev == "") || (next == "")) {
			Effects.errHandler("setButtons: Button IDs can't be empty", 2);
			return;
		}
		
		// Sets Next & Prev Buttons
		Effects.Slide.prevBtn = prev;
		Effects.Slide.nextBtn = next;
		Effects.Slide.enableButtons(true);
		
		// Sets Auto Button
		Effects.Slide.intervalBtn = interval;
		
		// If the auto button has 'active' class then activate
		if ($(interval).is('.active')) {
			Effects.Slide.setIntervalOptions(true);
		}
		
		// On Click Auto Button
		$(interval).bind('click', function() {
			Effects.Slide.setIntervalOptions(!$(interval).is('.active'));
		});
		
		// Modification: href="#" => href="javascript:void(0)"
		$(prev).attr('href','javascript:void(0)');
		$(next).attr('href','javascript:void(0)');
		$(interval).attr('href','javascript:void(0)');
	},
	
	/**
	 * Button Enable/Disable Function
	 * 
	 * @param {Boolean} bool
	 */
	enableButtons: function(bool) {
		
		if ((Effects.Slide.nextBtn == null) || (Effects.Slide.prevBtn == null))
			return;
		
		if (bool) {
			
			$(Effects.Slide.nextBtn).bind('click',function(){
				Effects.Slide.slideMe(1)
			});
			$(Effects.Slide.nextBtn).removeClass('disabled');
			
			$(Effects.Slide.prevBtn).bind('click',function(){
				Effects.Slide.slideMe(-1)
			})
			$(Effects.Slide.prevBtn).removeClass('disabled');
						
		} else {
			
			$(Effects.Slide.nextBtn).unbind('click');
			$(Effects.Slide.nextBtn).addClass('disabled');
			
			$(Effects.Slide.prevBtn).unbind('click');
			$(Effects.Slide.prevBtn).addClass('disabled');
		}
	},
	
	setIntervalOptions: function(enable, duration) {
		
		var status;
		
		if (duration)
			this.intervalDuration = duration;
	
		if (enable) {
			Effects.Slide.interval = setInterval(function(){ Effects.Slide.slideMe(1); },Effects.Slide.intervalDuration);
			Effects.Slide.intervalBool = true;
			status = "Enabled";
			$(Effects.Slide.intervalBtn).addClass('active');
		} else {
			clearInterval(Effects.Slide.interval);
			Effects.Slide.intervalBool = false;
			status = "Disabled";
			$(Effects.Slide.intervalBtn).removeClass('active');
		}
		
		Effects.errHandler("setIntervalOptions: Interval "+status+" with "+Effects.Slide.intervalDuration+"ms");
	}		
};

// Prototype Structure			
pEffectsSlide.prototype = Effects.Slide;
function pEffectsSlide(id, arr, buttons) {
	return Effects.Slide.init(id, arr, buttons);
}