var canvas = {};
/***************************几种画图模式********************************/
canvas.modes = {};
canvas.modes.FREEDOM_DRAW=1;//自由画线
canvas.modes.DRAW_CIRCLE=2;//自由画圆
canvas.modes.DRAW_LINE=3;//自由画直线
canvas.modes.DRAW_RECT=4;//自由画矩形
canvas.modes.ERASE=0;//自由擦除
/***********************************************************************/
canvas.settingMap={};
canvas.contextMap={};
canvas.defaultSetting={
	mode:canvas.modes.FREEDOM_DRAW,
	penColor:"black",
	bgColor:"white",
	lineWidth:1,
	width:"400px",
	height:"400px",
};
//获得setting
canvas.composeSetting = function(domId,setting){
	if(StringUtil.isNotEmpty($("#"+domId))){
		if(StringUtil.isEmpty(canvas.settingMap[domId])){
			//不能直接引用canvas.defaultSetting，会覆盖canvas.defaultSetting
			canvas.settingMap[domId]=JSON.parse(JSON.stringify(canvas.defaultSetting));
		}
		if(StringUtil.isNotEmpty(setting)){
			for(var key in setting){
				canvas.settingMap[domId][key]=setting[key];
			}
		}
	}
};

canvas.size = function(domId,wh){
	var cvs=document.getElementById(domId);
	var width = StringUtil.safeToString(wh[0],"400px");
	var height = StringUtil.safeToString(wh[1],"400px");
	var nc = document.createElement("canvas");
	var ctx = canvas.getContext(domId);
	cvs.width = width;
	cvs.height = height;
	nc.width = width;
	nc.height = height;

	nc.getContext("2d").drawImage(cvs,0,0);
	ctx.width = width;
	ctx.height = height;
	ctx.drawImage(nc,0,0);


};
//使外部setting生效
canvas.enableSetting = function(domId,setting){
	var ctx= canvas.getContext(domId);
	if(setting !== undefined){
		for(var key in setting){
			canvas.settingMap[domId][key]=setting[key];
		}
	}
	$("#"+domId).css("background",canvas.settingMap[domId]['bgColor']);
	ctx.strokeStyle=canvas.settingMap[domId]['penColor'];
	ctx.lineWidth=canvas.settingMap[domId]['lineWidth'];
	ctx.beginPath();
};
canvas.getContext = function(domId){
	var ctx = canvas.contextMap[domId];
	if(ctx === undefined){
		var cvs=document.getElementById(domId);
		ctx = cvs.getContext("2d");
		canvas.contextMap[domId] = ctx;
	}
	return ctx;
};
canvas.enterCanvasMode = function(domId,md){
	if(md !== undefined){
		canvas.settingMap[domId]['mode'] = parseInt(md);
	}
	var mode=canvas.settingMap[domId]['mode'];
	var ctx = canvas.getContext(domId);
	ctx.strokeStyle=canvas.settingMap[domId]['penColor'];
	ctx.lineWidth=canvas.settingMap[domId]['lineWidth'];
	if(mode===canvas.modes.FREEDOM_DRAW){
		canvas.freedomCanvas(domId);
	}else if(mode===canvas.modes.DRAW_CIRCLE){
		canvas.drawCircle(domId);
	}else if(mode===canvas.modes.DRAW_LINE){
		canvas.drawLine(domId);
	}else if(mode===canvas.modes.DRAW_RECT){
		canvas.drawRect(domId);
	}else if(mode===canvas.modes.ERASE){
		canvas.erase(domId);
	}
};
canvas.initCanvas = function(domId,setting) {
	canvas.composeSetting(domId,setting);
	canvas.enableSetting(domId);
	var cvs=document.getElementById(domId);
	var width = StringUtil.safeToString(canvas.settingMap[domId]['width'],"400px");
	var height = StringUtil.safeToString(canvas.settingMap[domId]['height'],"400px");
	cvs.width = width;
	cvs.height = height;
	canvas.contextMap[domId] = cvs.getContext("2d");
};
/*******************************************************对外使用******************************************************************/
canvas.beginCanvas = function(domId,setting){
	try{
		canvas.initCanvas(domId,setting);

		canvas.enterCanvasMode(domId);
		
	}catch(e){
		console.log("canvas初始化失败！");
		console.error(e);
	}
	
};

/*************************************************************************************************************************/



//自由画线初始化
canvas.freedomCanvas = function(domId){
	if(StringUtil.isNotEmpty($("#"+domId))){
		$("#"+domId).unbind();
		var cvs=document.getElementById(domId);
		var ctx=canvas.getContext(domId);
		var status = false;
		$(cvs).mousedown(function(event){
			status = true;
			ctx.moveTo(event.offsetX,event.offsetY);
			ctx.stroke();
		});	
		$(cvs).mouseup(function(event){
			status=false;
			ctx.stroke();
		});
		$(cvs).mousemove(function(event){
			if(status){
				ctx.lineTo(event.offsetX,event.offsetY);
				ctx.stroke();
			}
		});
		$(cvs).mouseleave(function(event){
			status=false;
		})
	}
};
//自由擦除
canvas.erase = function(domId){
	if($("#"+domId).length>0){
		$("#"+domId).unbind();
		var cvs=document.getElementById(domId);
		var ctx=canvas.getContext(domId);
		ctx.strokeStyle=canvas.settingMap[domId]['bgColor'];
		var status =false;
		$(cvs).mousedown(function(event){
			status =true;
			ctx.moveTo(event.offsetX,event.offsetY);
			ctx.stroke();
		});	
		$(cvs).mouseup(function(event){
			ctx.stroke();
			status =false;
		});
		$(cvs).mousemove(function(event){
			if(status){
				ctx.lineTo(event.offsetX,event.offsetY);
				ctx.stroke();	
			}
		});
		$(cvs).mouseleave(function(event){
			status =false;
		})
	}
};
//自由画矩形初始化
canvas.drawRect= function(domId){
	if(StringUtil.isNotEmpty($("#"+domId))){
		$("#"+domId).unbind();
		var cvs=document.getElementById(domId);
		var ctx=canvas.getContext(domId);
		var status =false;
		var x0=0;
		var y0=0;
		var zIndex=$(cvs).css("zIndex");
		$("#"+domId+"_tmp").remove();
		var tmpDiv=$("<div style='position:absolute;width:1px;height:1px;display:none;background:"+canvas.settingMap[domId]['penColor']+";opacity:0.2;border:"+
				StringUtil.safeToString(canvas.settingMap[domId]['lineWidth'],1)+"px solid "+canvas.settingMap[domId]['penColor']+";z-index:"+zIndex+";'>");
		var left=0;
		var top=0;
		$(tmpDiv).appendTo("body");
		$(tmpDiv).mousemove(function(event){
			$(tmpDiv).hide();
		});
		var onMouseUp = function(event,m){
			status =false;
			if(m !== undefined){
				ctx.rect(x0,y0,$(tmpDiv).offset().left + event.offsetX-x0,
					$(tmpDiv).offset().top-50 + event.offsetY-y0);
			}else{
				ctx.rect(x0,y0,event.offsetX-x0,event.offsetY-y0);
			}

			ctx.stroke();
			$(tmpDiv).hide();
		};
		$(tmpDiv).mouseup(function(e){
			onMouseUp(e,'asd');
		});
		$(cvs).mousedown(function(event){
			status =true;
			x0=event.offsetX;
			y0=event.offsetY;
			left=event.pageX;
			top=event.pageY;
			ctx.moveTo(event.offsetX,event.offsetY);
			$(tmpDiv).css({
				"left":left+"px",
				"top":top+"px",
				"width":(event.offsetX-x0)+"px",
				"height":(event.offsetY-y0)+"px"
			});
			$(tmpDiv).show();
		});	
		$(cvs).mouseup(onMouseUp);
		$(cvs).mousemove(function(event){
			if(status){
				$(tmpDiv).show();
				if(event.offsetX>=x0 && event.offsetY>=y0){
					$(tmpDiv).css({
						"left":left+"px",
						"top":top+"px",
						"width":(event.offsetX-x0)+"px",
						"height":(event.offsetY-y0)+"px"
					});
				}else if(event.offsetX>=x0 && event.offsetY<y0){
					$(tmpDiv).css({
						"left":left+"px",
						"top":(top-(y0-event.offsetY))+"px",
						"width":(event.offsetX-x0)+"px",
						"height":(y0-event.offsetY)+"px"
					});
				}else if(event.offsetX<x0 && event.offsetY>=y0){
					$(tmpDiv).css({
						"left":(left-(x0-event.offsetX))+"px",
						"top":top+"px",
						"width":(x0-event.offsetX)+"px",
						"height":(event.offsetY-y0)+"px"
					});
				}else if(event.offsetX<x0 && event.offsetY<y0){
					$(tmpDiv).css({
						"left":(left-(x0-event.offsetX))+"px",
						"top":(top-(y0-event.offsetY))+"px",
						"width":(x0-event.offsetX)+"px",
						"height":(y0-event.offsetY)+"px"
					});
				}
			}
		});
		$(cvs).mouseleave(function(event){
			//mouseDownMap[domId]=false;
		})
	}
};
//自由画直线初始化
canvas.drawLine = function(domId){
	if($("#"+domId).length>0){
		$("#"+domId).unbind();
		var cvs=document.getElementById(domId);
		var ctx=canvas.getContext(domId);
		ctx.moveTo(0,0);
		var x0=0;
		var y0=0;
		var status=false;
		var zIndex=$(cvs).css("zIndex");
		var tmpDiv=$("<div style='position:absolute;width:1px;height:1px;display:none;background:"+canvas.settingMap[domId]['penColor']+";z-index:"+zIndex+";'>");
		var left=0;
		var top=0;
		$(tmpDiv).appendTo("body");
		$(cvs).mousedown(function(event){
			status=true;
			x0=event.offsetX;
			y0=event.offsetY;
			left=event.pageX;
			top=event.pageY;
			$(tmpDiv).css({
				"left":left+"px",
				"top":top+"px",
				"width":"1px",
				"height":"1px"
			});
			$(tmpDiv).show();
		});	
		$(cvs).mouseup(function(event){
			if(status){
				$(tmpDiv).hide();
				ctx.moveTo(event.offsetX,event.offsetY);
				ctx.moveTo(x0,y0);
				ctx.lineTo(event.offsetX,event.offsetY);
				ctx.stroke();
			}
			status=false;
		});
		$(cvs).mousemove(function(event){
			if(status){
				var dx=	Math.abs(x0-event.offsetX);
				var dy=	Math.abs(y0-event.offsetY);
				var d=Math.sqrt(dx*dx+dy*dy);
				if(event.offsetX>=x0 && event.offsetY>=y0){
					$(tmpDiv).width(canvas.settingMap[domId]['lineWidth']);
					$(tmpDiv).height(dy-2);
					var arc=Math.acos((d*d+dy*dy-dx*dx)/2/d/dy)*360/2/Math.PI;
					$(tmpDiv).css({
						"left":(left+dx/2)+"px",
						"top":top+"px",
						"webkitTransform":"skewX("+arc+"deg)",
						"mozTransform":"skewX("+arc+"deg)",
						"oTransform":"skewX("+arc+"deg)",
					})
				}else if(event.offsetX>=x0 && event.offsetY<y0){
					$(tmpDiv).width(dx-2);
					$(tmpDiv).height(canvas.settingMap[domId]['lineWidth']);
					var arcy=-Math.acos((d*d+dx*dx-dy*dy)/2/d/dx)*360/2/Math.PI;
					$(tmpDiv).css({
						"left":left+"px",
						"top":(top-dy/2)+"px",
						"webkitTransform":"skewY("+arcy+"deg)",
						"mozTransform":"skewY("+arcy+"deg)",
						"oTransform":"skewY("+arcy+"deg)",
					})
				}else if(event.offsetX<x0 && event.offsetY>=y0){
					$(tmpDiv).width(canvas.settingMap[domId]['lineWidth']);
					$(tmpDiv).height(dy-2);
					var arcx=-(90-Math.acos((d*d+dx*dx-dy*dy)/2/d/dx)*360/2/Math.PI);
					$(tmpDiv).css({
						"left":(left-dx/2)+"px",
						"top":top+"px",
						"webkitTransform":"skewX("+arcx+"deg)",
						"mozTransform":"skewX("+arcx+"deg)",
						"oTransform":"skewX("+arcx+"deg)",
					})
				}else if(event.offsetX<x0 && event.offsetY<y0){
					$(tmpDiv).width(canvas.settingMap[domId]['lineWidth']);
					$(tmpDiv).height(dy-2);
					var arcx=-90-Math.acos((d*d+dx*dx-dy*dy)/2/d/dx)*360/2/Math.PI;
					$(tmpDiv).css({
						"left":(left-dx/2)+"px",
						"top":(top-dy)+"px",
						"webkitTransform":"skewX("+arcx+"deg)",
						"mozTransform":"skewX("+arcx+"deg)",
						"oTransform":"skewX("+arcx+"deg)",
					})
				}
			}
		});
		$(cvs).mouseleave(function(event){
			//mouseDownMap[domId]=false;
		})
	}
};
//自由画圆初始化
canvas.drawCircle = function(domId){
	if($("#"+domId).length>0){
		$("#"+domId).unbind();
		var cvs=document.getElementById(domId);
		var ctx=canvas.getContext(domId);
		var x0=0;
		var y0=0;
		var status =false;
		//border-radius: 50%;
		var zIndex=$(cvs).css("zIndex");
		$("#"+domId+"_tmp").remove();
		var tmpDiv=$("<div id='"+domId+"_tmp' "+
			"style='position:fixed;border-radius: 50%;border:"+canvas.settingMap[domId]['lineWidth']+"px solid "+canvas.settingMap[domId]['penColor']+";display:none;opacity:0.2;width:0px;height:0px;background:"+canvas.settingMap[domId]['penColor']+";z-index:"+zIndex+";' >");
		$(tmpDiv).appendTo("body");
		var onMouseUp = function(event,m){
			if(status){
				var x;
				var y;
				var dx;
				var dy;
				var r;
				if(m !== undefined){
					x = (x0+$(tmpDiv).offset().left + event.offsetX)/2;
					y = (y0+$(tmpDiv).offset().top-50 + event.offsetY)/2;
					dx=	Math.abs(x0-$(tmpDiv).offset().left - event.offsetX);
					dy=	Math.abs(y0-$(tmpDiv).offset().top+50 - event.offsetY);
					//半径
					r =Math.sqrt(dx*dx+dy*dy)/2;
				}else{
					//圆心坐标
					x=(x0+event.offsetX)/2;
					y=(y0+event.offsetY)/2;
					//鼠标点击和释放坐标差
					dx=	Math.abs(x0-event.offsetX);
					dy=	Math.abs(y0-event.offsetY);
					//半径
					r =Math.sqrt(dx*dx+dy*dy)/2;
				}


				//console.log(x,y,dx,dy,r);
				ctx.beginPath();
				ctx.arc(x,y,r,0,2*Math.PI);
				ctx.stroke();
				$(tmpDiv).hide();
			}
			status=false;
		};

		$(tmpDiv).mouseup(function(e){
			onMouseUp(e,'asd');
		});
		$(tmpDiv).mousemove(function(e){
			$(tmpDiv).hide();
		});

		$(cvs).mousedown(function(event){
			status=true;
			$(tmpDiv).width(0);
			$(tmpDiv).height(0);
			//$(tmpDiv).show();
			ctx.moveTo(event.offsetX,event.offsetY);
			x0=event.offsetX;
			y0=event.offsetY;
			//console.log(x0,y0);
			$(tmpDiv).css("left",x0+"px");
			$(tmpDiv).css("top",y0+"px");
		});	
		$(cvs).mouseup(onMouseUp);
		$(cvs).mousemove(function(event){
			if(status){
				$(tmpDiv).show();
				//console.log($(tmpDiv).offset().left-x0);
				var x=(x0+event.offsetX)/2;
				var y=(y0+event.offsetY)/2;
				var dx=	Math.abs(x0-event.offsetX);
				var dy=	Math.abs(y0-event.offsetY);
				var r=Math.sqrt(dx*dx+dy*dy)/2;
				$(tmpDiv).width(2*r-canvas.settingMap[domId]['lineWidth']-canvas.settingMap[domId]['lineWidth']);
				$(tmpDiv).height(2*r-canvas.settingMap[domId]['lineWidth']-canvas.settingMap[domId]['lineWidth']);
				//计算并设置div的位置
				if(event.offsetX>=x0&&event.offsetY>=y0){
					$(tmpDiv).css("left",(event.pageX-(2*r-r+dx/2))+"px");
					$(tmpDiv).css("top",(event.pageY-(2*r-r+dy/2))+"px");
				}else if(event.offsetX<x0&&event.offsetY<y0){
					$(tmpDiv).css("left",(event.pageX-(r-dx/2))+"px");
					$(tmpDiv).css("top",(event.pageY-(r-dy/2))+"px");
				}else if(event.offsetX>x0&&event.offsetY<y0){
					$(tmpDiv).css("left",(event.pageX-(2*r-r+dx/2))+"px");
					$(tmpDiv).css("top",(event.pageY-(r-dy/2))+"px");
				}else if(event.offsetX<x0&&event.offsetY>y0){
					$(tmpDiv).css("left",(event.pageX-(r-dx/2))+"px");
					$(tmpDiv).css("top",(event.pageY-(2*r-r+dy/2))+"px");
				}

				
				
			}
		});
		$(cvs).mouseleave(function(event){
			//mouseDownMap[domId]=false;
		})
	}
};
